/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.type.TypeHierarchy;

class ConstructedItemType
extends ItemType {
    private net.sf.saxon.type.ItemType underlyingType;
    private Processor processor;

    protected ConstructedItemType(net.sf.saxon.type.ItemType underlyingType, Processor processor) {
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        if (underlyingType == null) {
            throw new NullPointerException("underlyingType");
        }
        this.processor = processor;
        this.underlyingType = underlyingType;
    }

    @Override
    public boolean matches(XdmItem item) {
        return this.underlyingType.matchesItem((Item)item.getUnderlyingValue(), false, this.processor.getUnderlyingConfiguration());
    }

    @Override
    public boolean subsumes(ItemType other) {
        TypeHierarchy th = this.processor.getUnderlyingConfiguration().getTypeHierarchy();
        return th.isSubType(other.getUnderlyingItemType(), this.underlyingType);
    }

    @Override
    public net.sf.saxon.type.ItemType getUnderlyingItemType() {
        return this.underlyingType;
    }

    protected Processor getProcessor() {
        return this.processor;
    }
}

