/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;

public class PrependIterator
implements AxisIterator {
    NodeInfo start;
    AxisIterator base;
    int position = 0;

    public PrependIterator(NodeInfo start, AxisIterator base) {
        this.start = start;
        this.base = base;
    }

    @Override
    public boolean moveNext() {
        return this.next() != null;
    }

    @Override
    public Item next() {
        if (this.position == 0) {
            this.position = 1;
            return this.start;
        }
        Item n = this.base.next();
        this.position = n == null ? -1 : ++this.position;
        return n;
    }

    @Override
    public Item current() {
        if (this.position() == 1) {
            return this.start;
        }
        if (this.position < 1) {
            return null;
        }
        return this.base.current();
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public AxisIterator iterateAxis(byte axis, NodeTest test) {
        return ((NodeInfo)this.current()).iterateAxis(axis, test);
    }

    @Override
    public Value atomize() throws XPathException {
        return ((NodeInfo)this.current()).atomize();
    }

    @Override
    public CharSequence getStringValue() {
        return ((NodeInfo)this.current()).getStringValueCS();
    }

    @Override
    public SequenceIterator getAnother() {
        return new PrependIterator(this.start, this.base);
    }

    @Override
    public int getProperties() {
        return 0;
    }
}

