/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Iterator;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.instruct.DivisibleInstruction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public abstract class SimpleNodeConstructor
extends Instruction
implements DivisibleInstruction {
    protected Expression select = null;

    public void setSelect(Expression select, Configuration config) throws XPathException {
        this.select = select;
        this.adoptChildExpression(select);
    }

    public Expression getSelect() {
        return this.select;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.select != null) {
            this.select = visitor.simplify(this.select);
        }
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public abstract void localTypeCheck(ExpressionVisitor var1, ItemType var2) throws XPathException;

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.localTypeCheck(visitor, contextItemType);
        if (this.select != null) {
            Expression arg;
            ItemType itemType;
            Expression valSelect;
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            this.select = visitor.typeCheck(this.select, contextItemType);
            if (this.select instanceof ValueOf && th.isSubType((valSelect = ((ValueOf)this.select).getSelect()).getItemType(th), BuiltInAtomicType.STRING) && !Cardinality.allowsMany(valSelect.getCardinality())) {
                this.select = valSelect;
            }
            if (!this.select.getItemType(th).isAtomicType()) {
                Atomizer atomizer = new Atomizer(this.select);
                ExpressionTool.copyLocationInfo(this.select, atomizer);
                this.select = visitor.simplify(atomizer);
                this.select = visitor.typeCheck(atomizer, contextItemType);
            }
            if (!th.isSubType(itemType = this.select.getItemType(th), BuiltInAtomicType.STRING) && !th.isSubType(itemType, BuiltInAtomicType.UNTYPED_ATOMIC)) {
                this.select = new AtomicSequenceConverter(this.select, BuiltInAtomicType.STRING);
            }
            if (this.select instanceof StringFn) {
                StringFn fn = (StringFn)this.select;
                Expression arg2 = fn.getArguments()[0];
                if (arg2.getItemType(th) == BuiltInAtomicType.UNTYPED_ATOMIC && !Cardinality.allowsMany(arg2.getCardinality())) {
                    this.select = arg2;
                }
            } else if (this.select instanceof CastExpression && ((CastExpression)this.select).getTargetType() == BuiltInAtomicType.STRING && (arg = ((CastExpression)this.select).getBaseExpression()).getItemType(th) == BuiltInAtomicType.UNTYPED_ATOMIC && !Cardinality.allowsMany(arg.getCardinality())) {
                this.select = arg;
            }
            this.adoptChildExpression(this.select);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.optimize(this.select, contextItemType);
            this.adoptChildExpression(this.select);
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator(this.select);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        CharSequence value = this.expandChildren(context);
        this.processValue(value, context);
        return null;
    }

    @Override
    public final void processLeft(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        SequenceReceiver out = context.getReceiver();
        state.push(out);
        SequenceOutputter out2 = new SequenceOutputter();
        out2.setPipelineConfiguration(out.getPipelineConfiguration());
        context.setReceiver(out2);
    }

    @Override
    public final void processRight(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        Item item;
        XPathContext context = contextStack.peek();
        SequenceOutputter out2 = (SequenceOutputter)context.getReceiver();
        SequenceReceiver out = (SequenceReceiver)state.pop();
        SequenceIterator iter = out2.iterate();
        FastStringBuffer buff = new FastStringBuffer(100);
        while ((item = iter.next()) != null) {
            buff.append(item.getStringValueCS());
        }
        context.setReceiver(out);
        this.processValue(buff, context);
    }

    protected abstract void processValue(CharSequence var1, XPathContext var2) throws XPathException;

    public final CharSequence expandChildren(XPathContext context) throws XPathException {
        Item item = this.select.evaluateItem(context);
        if (item == null) {
            return "";
        }
        return item.getStringValueCS();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        String content = this.select == null ? "" : this.select.evaluateAsString(context).toString();
        content = this.checkContent(content, context);
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        Orphan o = new Orphan(context.getConfiguration());
        o.setNodeKind((short)this.getItemType(th).getPrimitiveType());
        o.setStringValue(content);
        o.setNameCode(this.evaluateNameCode(context));
        return o;
    }

    protected String checkContent(String data, XPathContext context) throws XPathException {
        return data;
    }

    public int evaluateNameCode(XPathContext context) throws XPathException {
        return -1;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return SingletonIterator.makeIterator(this.evaluateItem(context));
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.select != null) {
            this.select = this.doPromotion(this, this.select, offer);
        }
        super.promoteInst(offer);
    }
}

