/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.GlobalParameterSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;

public class Executable
implements Serializable {
    private transient Configuration config;
    private Mode stripperRules;
    private boolean stripsWhitespace;
    private RuleManager ruleManager;
    private KeyManager keyManager;
    private SlotManager globalVariableMap;
    private HashMap<StructuredQName, GlobalVariable> compiledGlobalVariables;
    private Properties defaultOutputProperties;
    private HashMap<StructuredQName, Template> namedTemplateTable;
    private int largestPatternStackFrame = 0;
    private CollationMap collationTable;
    private HashMap<StructuredQName, IntHashMap<String>> characterMapIndex;
    private LocationMap locationMap;
    private HashMap<String, List<QueryModule>> queryLibraryModules;
    private boolean stripsInputTypeAnnotations;
    private FunctionLibrary functionLibrary;
    private int hostLanguage = 50;
    private HashSet<StructuredQName> requiredParams = null;
    private HashMap<StructuredQName, Properties> outputDeclarations = null;
    private String reasonUnableToCompile = null;
    private boolean createsSecondaryResult = false;
    private boolean schemaAware = false;
    private StructuredQName initialContextItemVariableName = null;

    public Executable(Configuration config) {
        this.setConfiguration(config);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setRuleManager(RuleManager rm) {
        this.ruleManager = rm;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public Template getNamedTemplate(StructuredQName qName) {
        if (this.namedTemplateTable == null) {
            return null;
        }
        return this.namedTemplateTable.get(qName);
    }

    public void putNamedTemplate(StructuredQName templateName, Template template) {
        if (this.namedTemplateTable == null) {
            this.namedTemplateTable = new HashMap(32);
        }
        this.namedTemplateTable.put(templateName, template);
    }

    public Iterator<Template> iterateNamedTemplates() {
        if (this.namedTemplateTable == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.namedTemplateTable.values().iterator();
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void setFunctionLibrary(FunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public void setCharacterMapIndex(HashMap<StructuredQName, IntHashMap<String>> cmi) {
        this.characterMapIndex = cmi;
    }

    public HashMap<StructuredQName, IntHashMap<String>> getCharacterMapIndex() {
        if (this.characterMapIndex == null) {
            this.characterMapIndex = new HashMap(10);
        }
        return this.characterMapIndex;
    }

    public void setStripperRules(Mode rules) {
        this.stripperRules = rules;
    }

    public Mode getStripperRules() {
        return this.stripperRules;
    }

    public void setStripsWhitespace(boolean strips) {
        this.stripsWhitespace = strips;
    }

    public Stripper newStripper() {
        return new Stripper(this.stripperRules);
    }

    public boolean stripsWhitespace() {
        return this.stripsWhitespace;
    }

    public void setStripsInputTypeAnnotations(boolean strips) {
        this.stripsInputTypeAnnotations = strips;
    }

    public boolean stripsInputTypeAnnotations() {
        return this.stripsInputTypeAnnotations;
    }

    public void setKeyManager(KeyManager km) {
        this.keyManager = km;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager(this.getConfiguration());
        }
        return this.keyManager;
    }

    public void setDefaultOutputProperties(Properties properties) {
        this.defaultOutputProperties = properties;
    }

    public Properties getDefaultOutputProperties() {
        if (this.defaultOutputProperties == null) {
            this.defaultOutputProperties = new Properties();
        }
        return this.defaultOutputProperties;
    }

    public void setOutputProperties(StructuredQName qName, Properties properties) {
        if (this.outputDeclarations == null) {
            this.outputDeclarations = new HashMap(5);
        }
        this.outputDeclarations.put(qName, properties);
    }

    public Properties getOutputProperties(StructuredQName qName) {
        if (this.outputDeclarations == null) {
            return null;
        }
        return this.outputDeclarations.get(qName);
    }

    public void setCollationTable(CollationMap table) {
        this.collationTable = table;
    }

    public CollationMap getCollationTable() {
        if (this.collationTable == null) {
            this.collationTable = new CollationMap(this.config);
        }
        return this.collationTable;
    }

    public StringCollator getNamedCollation(String name) {
        if (this.collationTable == null) {
            this.collationTable = new CollationMap(this.config);
        }
        return this.collationTable.getNamedCollation(name);
    }

    public void addQueryLibraryModule(QueryModule module) {
        String uri;
        List<QueryModule> existing;
        if (this.queryLibraryModules == null) {
            this.queryLibraryModules = new HashMap(5);
        }
        if ((existing = this.queryLibraryModules.get(uri = module.getModuleNamespace())) == null) {
            existing = new ArrayList<QueryModule>(5);
            existing.add(module);
            this.queryLibraryModules.put(uri, existing);
        } else {
            existing.add(module);
        }
    }

    public List<QueryModule> getQueryLibraryModules(String namespace) {
        if (this.queryLibraryModules == null) {
            return null;
        }
        return this.queryLibraryModules.get(namespace);
    }

    public QueryModule getQueryModuleWithSystemId(String systemId, QueryModule topModule) {
        if (systemId.equals(topModule.getSystemId())) {
            return topModule;
        }
        Iterator miter = this.getQueryLibraryModules();
        while (miter.hasNext()) {
            QueryModule sqc = (QueryModule)miter.next();
            if (!sqc.getSystemId().equals(systemId)) continue;
            return sqc;
        }
        return null;
    }

    public Iterator getQueryLibraryModules() {
        if (this.queryLibraryModules == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<QueryModule> modules = new ArrayList<QueryModule>();
        for (List<QueryModule> mods : this.queryLibraryModules.values()) {
            modules.addAll(mods);
        }
        return modules.iterator();
    }

    public void fixupQueryModules(QueryModule main) throws XPathException {
        main.bindUnboundVariables();
        if (this.queryLibraryModules != null) {
            for (List<QueryModule> modules : this.queryLibraryModules.values()) {
                for (QueryModule env : modules) {
                    env.bindUnboundVariables();
                }
            }
        }
        List<GlobalVariableDefinition> varDefinitions = main.fixupGlobalVariables(main.getGlobalStackFrameMap());
        main.bindUnboundFunctionCalls();
        if (this.queryLibraryModules != null) {
            for (List<QueryModule> modules : this.queryLibraryModules.values()) {
                for (QueryModule env : modules) {
                    env.bindUnboundFunctionCalls();
                }
            }
        }
        main.checkForCircularities(varDefinitions, main.getGlobalFunctionLibrary());
        main.fixupGlobalFunctions();
        main.typeCheckGlobalVariables(varDefinitions);
        main.optimizeGlobalFunctions();
    }

    public void setPatternSlotSpace(int patternLocals) {
        this.largestPatternStackFrame = patternLocals;
    }

    public GlobalVariable getGlobalVariable(StructuredQName name) {
        if (this.compiledGlobalVariables != null) {
            return this.compiledGlobalVariables.get(name);
        }
        return null;
    }

    public SlotManager getGlobalVariableMap() {
        if (this.globalVariableMap == null) {
            this.globalVariableMap = this.config.makeSlotManager();
        }
        return this.globalVariableMap;
    }

    public HashMap<StructuredQName, GlobalVariable> getCompiledGlobalVariables() {
        return this.compiledGlobalVariables;
    }

    public void explainGlobalVariables(ExpressionPresenter presenter) {
        if (this.compiledGlobalVariables != null) {
            presenter.startElement("globalVariables");
            for (GlobalVariable var : this.compiledGlobalVariables.values()) {
                presenter.startElement("declareVariable");
                presenter.emitAttribute("name", var.getVariableQName().getDisplayName());
                if (var.isAssignable()) {
                    presenter.emitAttribute("assignable", "true");
                }
                if (var.getSelectExpression() != null) {
                    var.getSelectExpression().explain(presenter);
                }
                presenter.endElement();
            }
            presenter.endElement();
        }
    }

    public void registerGlobalVariable(GlobalVariable variable) {
        if (this.compiledGlobalVariables == null) {
            this.compiledGlobalVariables = new HashMap(32);
        }
        this.compiledGlobalVariables.put(variable.getVariableQName(), variable);
    }

    public void initializeBindery(Bindery bindery) {
        bindery.allocateGlobals(this.getGlobalVariableMap());
    }

    public int getLargestPatternStackFrame() {
        return this.largestPatternStackFrame;
    }

    public void setLocationMap(LocationMap map) {
        this.locationMap = map;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void addRequiredParam(StructuredQName qName) {
        if (this.requiredParams == null) {
            this.requiredParams = new HashSet(5);
        }
        this.requiredParams.add(qName);
    }

    public void checkAllRequiredParamsArePresent(GlobalParameterSet params) throws XPathException {
        if (this.requiredParams == null) {
            return;
        }
        for (StructuredQName req : this.requiredParams) {
            if (params != null && params.get(req) != null) continue;
            XPathException err = new XPathException("No value supplied for required parameter " + req.getDisplayName());
            err.setErrorCode("XTDE0050");
            throw err;
        }
    }

    public void setReasonUnableToCompile(String reason) {
        this.reasonUnableToCompile = reason;
    }

    public String getReasonUnableToCompile() {
        return this.reasonUnableToCompile;
    }

    public void explainNamedTemplates(ExpressionPresenter presenter) {
        presenter.startElement("namedTemplates");
        if (this.namedTemplateTable != null) {
            for (Template t : this.namedTemplateTable.values()) {
                presenter.startElement("template");
                presenter.emitAttribute("name", t.getTemplateName().getDisplayName());
                presenter.emitAttribute("line", String.valueOf(t.getLineNumber()));
                presenter.emitAttribute("module", t.getSystemId());
                if (t.getBody() != null) {
                    t.getBody().explain(presenter);
                }
                presenter.endElement();
            }
        }
        presenter.endElement();
    }

    public void setCreatesSecondaryResult(boolean flag) {
        this.createsSecondaryResult = flag;
    }

    public boolean createsSecondaryResult() {
        return this.createsSecondaryResult;
    }

    public void setInitialContextItemVariableName(StructuredQName name) {
        this.initialContextItemVariableName = name;
    }

    public StructuredQName getInitialContextItemVariableName() {
        return this.initialContextItemVariableName;
    }

    public void setSchemaAware(boolean aware) {
        if (aware && !this.config.isLicensedFeature(1)) {
            throw new IllegalArgumentException("Schema-aware processing is not possible: no License");
        }
        this.schemaAware = aware;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }
}

