/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class ApplyImports
extends Instruction {
    WithParam[] actualParams = null;
    WithParam[] tunnelParams = null;

    public void setActualParameters(WithParam[] actualParams, WithParam[] tunnelParams) {
        this.actualParams = actualParams;
        this.tunnelParams = tunnelParams;
    }

    @Override
    public int getInstructionNameCode() {
        return 129;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        WithParam.simplify(this.actualParams, visitor);
        WithParam.simplify(this.tunnelParams, visitor);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextItemType);
        WithParam.typeCheck(this.tunnelParams, visitor, contextItemType);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        WithParam.optimize(visitor, this.actualParams, contextItemType);
        WithParam.optimize(visitor, this.tunnelParams, contextItemType);
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 30;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        WithParam.promoteParams(this, this.actualParams, offer);
        WithParam.promoteParams(this, this.tunnelParams, offer);
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList list = new ArrayList(10);
        WithParam.getXPathExpressions(this.actualParams, list);
        WithParam.getXPathExpressions(this.tunnelParams, list);
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (WithParam.replaceXPathExpression(this.actualParams, original, replacement)) {
            found = true;
        }
        if (WithParam.replaceXPathExpression(this.tunnelParams, original, replacement)) {
            found = true;
        }
        return found;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        ParameterSet params = ApplyImports.assembleParams(context, this.actualParams);
        ParameterSet tunnels = ApplyImports.assembleTunnelParams(context, this.tunnelParams);
        Rule currentTemplateRule = context.getCurrentTemplateRule();
        if (currentTemplateRule == null) {
            XPathException e = new XPathException("There is no current template rule");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0560");
            e.setLocator(this);
            throw e;
        }
        Template currentTemplate = (Template)currentTemplateRule.getAction();
        int min = currentTemplate.getMinImportPrecedence();
        int max = currentTemplate.getPrecedence() - 1;
        Mode mode = context.getCurrentMode();
        if (mode == null) {
            mode = controller.getRuleManager().getDefaultMode();
        }
        if (context.getCurrentIterator() == null) {
            XPathException e = new XPathException("Cannot call xsl:apply-imports when there is no context item");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0565");
            e.setLocator(this);
            throw e;
        }
        Item currentItem = context.getCurrentIterator().current();
        if (!(currentItem instanceof NodeInfo)) {
            XPathException e = new XPathException("Cannot call xsl:apply-imports when context item is not a node");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0565");
            e.setLocator(this);
            throw e;
        }
        NodeInfo node = (NodeInfo)currentItem;
        Rule rule = controller.getRuleManager().getTemplateRule(node, mode, min, max, context);
        if (rule == null) {
            ApplyTemplates.defaultAction(node, params, tunnels, context, this.getLocationId());
        } else {
            XPathContextMajor c2 = context.newContext();
            Template nh = (Template)rule.getAction();
            c2.setOrigin(this);
            c2.setOriginatingConstructType(2008);
            c2.setLocalParameters(params);
            c2.setTunnelParameters(tunnels);
            c2.openStackFrame(nh.getStackFrameMap());
            c2.setCurrentTemplateRule(rule);
            nh.apply(c2);
        }
        return null;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("applyImports");
        if (this.actualParams != null && this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.displayExpressions(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        if (this.tunnelParams != null && this.tunnelParams.length > 0) {
            out.startSubsidiaryElement("tunnelParams");
            WithParam.displayExpressions(this.tunnelParams, out);
            out.endSubsidiaryElement();
        }
    }
}

