/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.IntToIntHashMap;
import net.sf.saxon.sort.IntToIntMap;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.StringValue;

public class Translate
extends SystemFunction {
    private IntToIntMap staticMap = null;

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.typeCheck(visitor, contextItemType);
        if (e == this && this.argument[1] instanceof StringLiteral && this.argument[2] instanceof StringLiteral) {
            this.staticMap = Translate.buildMap((StringValue)((StringLiteral)this.argument[1]).getValue(), (StringValue)((StringLiteral)this.argument[2]).getValue());
        }
        return e;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        StringValue sv1 = (StringValue)this.argument[0].evaluateItem(context);
        if (sv1 == null) {
            return StringValue.EMPTY_STRING;
        }
        if (this.staticMap != null) {
            CharSequence in = sv1.getStringValueCS();
            CharSequence sb = Translate.translateUsingMap(in, this.staticMap);
            return new StringValue(sb);
        }
        StringValue sv2 = (StringValue)this.argument[1].evaluateItem(context);
        StringValue sv3 = (StringValue)this.argument[2].evaluateItem(context);
        return StringValue.makeStringValue(Translate.translate(sv1, sv2, sv3));
    }

    public IntToIntMap getStaticMap() {
        return this.staticMap;
    }

    public static CharSequence translate(StringValue sv0, StringValue sv1, StringValue sv2) {
        if (sv0.containsSurrogatePairs() || sv1.containsSurrogatePairs() || sv2.containsSurrogatePairs()) {
            return Translate.translateUsingMap(sv0.getStringValueCS(), Translate.buildMap(sv1, sv2));
        }
        if (sv0.getStringLength() * sv1.getStringLength() > 1000) {
            return Translate.translateUsingMap(sv0.getStringValueCS(), Translate.buildMap(sv1, sv2));
        }
        CharSequence cs0 = sv0.getStringValueCS();
        CharSequence cs1 = sv1.getStringValueCS();
        CharSequence cs2 = sv2.getStringValueCS();
        String st1 = cs1.toString();
        FastStringBuffer sb = new FastStringBuffer(cs0.length());
        int s2len = cs2.length();
        int s0len = cs0.length();
        int i = 0;
        while (i < s0len) {
            char c = cs0.charAt(i);
            int j = st1.indexOf(c);
            if (j < s2len) {
                sb.append(j < 0 ? c : cs2.charAt(j));
            }
            ++i;
        }
        return sb;
    }

    private static IntToIntMap buildMap(StringValue arg1, StringValue arg2) {
        int[] a1 = arg1.expand();
        int[] a2 = arg2.expand();
        IntToIntHashMap map = new IntToIntHashMap(a1.length, 0.5);
        int i = 0;
        while (i < a1.length) {
            if (!map.find(a1[i])) {
                map.put(a1[i], i > a2.length - 1 ? -1 : a2[i]);
            }
            ++i;
        }
        return map;
    }

    public static CharSequence translateUsingMap(CharSequence in, IntToIntMap map) {
        int len = in.length();
        FastStringBuffer sb = new FastStringBuffer(len);
        int i = 0;
        while (i < len) {
            int charval;
            int c = in.charAt(i);
            if (c >= 55296 && c <= 56319) {
                charval = (c - 55296) * 1024 + (in.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                charval = c;
            }
            int newchar = map.get(charval);
            if (newchar == Integer.MAX_VALUE) {
                newchar = charval;
            }
            if (newchar != -1) {
                if (newchar < 65536) {
                    sb.append((char)newchar);
                } else {
                    sb.append((char)((newchar -= 65536) / 1024 + 55296));
                    sb.append((char)(newchar % 1024 + 56320));
                }
            }
            ++i;
        }
        return sb;
    }
}

