/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Stack;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.DivisibleInstruction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;

public class StringFn
extends SystemFunction
implements DivisibleInstruction {
    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault();
        this.argument[0].setFlattened(true);
        return this.simplifyArguments(visitor);
    }

    @Override
    public PathMap.PathMapNodeSet addDocToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodes) {
        PathMap.PathMapNodeSet result = this.argument[0].addToPathMap(pathMap, pathMapNodes);
        if (result != null) {
            result.setAtomized();
        }
        return null;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        try {
            Item arg = this.argument[0].evaluateItem(c);
            if (arg == null) {
                return StringValue.EMPTY_STRING;
            }
            if (arg instanceof StringValue && ((StringValue)arg).getTypeLabel() == BuiltInAtomicType.STRING) {
                return arg;
            }
            return StringValue.makeStringValue(arg.getStringValueCS());
        }
        catch (UnsupportedOperationException e) {
            XPathException err = new XPathException(e.getMessage(), "FOTY0014");
            err.setLocator(this);
            err.setXPathContext(c);
            throw err;
        }
    }

    @Override
    public void processLeft(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        SequenceReceiver out = context.getReceiver();
        state.push(out);
        SequenceOutputter out2 = new SequenceOutputter();
        out2.setPipelineConfiguration(out.getPipelineConfiguration());
        context.setReceiver(out2);
    }

    @Override
    public void processRight(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        CharSequence value = ((SequenceOutputter)context.getReceiver()).getFirstItem().getStringValueCS();
        SequenceReceiver out = (SequenceReceiver)state.pop();
        context.setReceiver(out);
        out.append(new StringValue(value), 0, 0);
    }
}

