/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FormatNumber
extends SystemFunction {
    private NamespaceResolver nsContext = null;
    private DecimalFormatManager decimalFormatManager = null;
    private DecimalSymbols decimalFormatSymbols = null;
    private transient String picture = null;
    private SubPicture[] subPictures = null;
    private transient boolean checked = false;

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(visitor);
        this.decimalFormatManager = env.getDecimalFormatManager();
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        if (this.argument[1] instanceof StringLiteral) {
            this.picture = ((StringLiteral)this.argument[1]).getStringValue();
        }
        if (this.argument.length == 3) {
            if (this.argument[2] instanceof StringLiteral) {
                StructuredQName qName;
                String lexicalName = ((StringLiteral)this.argument[2]).getStringValue();
                try {
                    qName = StructuredQName.fromLexicalQName(lexicalName, false, visitor.getConfiguration().getNameChecker(), env.getNamespaceResolver());
                }
                catch (XPathException e) {
                    XPathException se = new XPathException("Invalid decimal format name. " + e.getMessage());
                    se.setErrorCode("XTDE1280");
                    throw se;
                }
                this.decimalFormatSymbols = this.decimalFormatManager.getNamedDecimalFormat(qName);
                if (this.decimalFormatSymbols == null) {
                    XPathException se = new XPathException("Unknown decimal format name " + lexicalName);
                    se.setErrorCode("XTDE1280");
                    throw se;
                }
            } else {
                this.nsContext = env.getNamespaceResolver();
            }
        } else {
            this.decimalFormatSymbols = this.decimalFormatManager.getDefaultDecimalFormat();
        }
    }

    private SubPicture[] getSubPictures(String picture, DecimalSymbols dfs) throws XPathException {
        int[] picture4 = StringValue.expand(picture);
        SubPicture[] pics = new SubPicture[2];
        if (picture4.length == 0) {
            XPathException err = new XPathException("format-number() picture is zero-length");
            err.setErrorCode("XTDE1310");
            throw err;
        }
        int sep = -1;
        int c = 0;
        while (c < picture4.length) {
            if (picture4[c] == dfs.patternSeparator) {
                if (c == 0) {
                    this.grumble("first subpicture is zero-length");
                } else if (sep >= 0) {
                    this.grumble("more than one pattern separator");
                } else if (sep == picture4.length - 1) {
                    this.grumble("second subpicture is zero-length");
                }
                sep = c;
            }
            ++c;
        }
        if (sep < 0) {
            pics[0] = new SubPicture(picture4, dfs);
            pics[1] = null;
        } else {
            int[] pic0 = new int[sep];
            System.arraycopy(picture4, 0, pic0, 0, sep);
            int[] pic1 = new int[picture4.length - sep - 1];
            System.arraycopy(picture4, sep + 1, pic1, 0, picture4.length - sep - 1);
            pics[0] = new SubPicture(pic0, dfs);
            pics[1] = new SubPicture(pic1, dfs);
        }
        return pics;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    @Override
    public Expression copy() {
        FormatNumber fn = (FormatNumber)super.copy();
        fn.nsContext = this.nsContext;
        fn.decimalFormatManager = this.decimalFormatManager;
        fn.decimalFormatSymbols = this.decimalFormatSymbols;
        fn.picture = this.picture;
        fn.subPictures = this.subPictures;
        return fn;
    }

    @Override
    public CharSequence evaluateAsString(XPathContext context) throws XPathException {
        SubPicture[] pics;
        int numArgs = this.argument.length;
        DecimalSymbols dfs = this.decimalFormatSymbols;
        AtomicValue av0 = (AtomicValue)this.argument[0].evaluateItem(context);
        if (av0 == null) {
            av0 = DoubleValue.NaN;
        }
        NumericValue number = (NumericValue)av0;
        if (dfs == null) {
            DecimalFormatManager dfm = this.decimalFormatManager;
            if (numArgs == 2) {
                dfs = dfm.getDefaultDecimalFormat();
            } else {
                String lexicalName = this.argument[2].evaluateItem(context).getStringValue();
                StructuredQName qName = null;
                try {
                    qName = StructuredQName.fromLexicalQName(lexicalName, false, context.getConfiguration().getNameChecker(), this.nsContext);
                }
                catch (XPathException e) {
                    XPathException err = new XPathException("Invalid decimal format name. " + e.getMessage());
                    err.setErrorCode("XTDE1280");
                    err.setLocator(this);
                    err.setXPathContext(context);
                    throw err;
                }
                dfs = dfm.getNamedDecimalFormat(qName);
                if (dfs == null) {
                    XPathException err = new XPathException("format-number function: decimal-format '" + lexicalName + "' is not defined");
                    err.setErrorCode("XTDE1280");
                    err.setLocator(this);
                    err.setXPathContext(context);
                    throw err;
                }
            }
        }
        if ((pics = this.subPictures) == null) {
            String format = this.argument[1].evaluateItem(context).getStringValue();
            pics = this.getSubPictures(format, dfs);
        }
        return this.formatNumber(number, pics, dfs);
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        return new StringValue(this.evaluateAsString(c));
    }

    private CharSequence formatNumber(NumericValue number, SubPicture[] subPictures, DecimalSymbols dfs) {
        SubPicture pic;
        NumericValue absN = number;
        String minusSign = "";
        if (number.signum() < 0.0) {
            absN = number.negate();
            if (subPictures[1] == null) {
                pic = subPictures[0];
                minusSign = "" + FormatNumber.unicodeChar(dfs.minusSign);
            } else {
                pic = subPictures[1];
            }
        } else {
            pic = subPictures[0];
        }
        return pic.format(absN, dfs, minusSign);
    }

    private void grumble(String s) throws XPathException {
        this.dynamicError("format-number picture: " + s, "XTDE1310", null);
    }

    /*
     * Unable to fully structure code
     */
    public static BigDecimal adjustToDecimal(double value, int precision) {
        block12: {
            block11: {
                zeros = precision == 1 ? "00000" : "000000000";
                nines = precision == 1 ? "99999" : "999999999";
                initial = new BigDecimal(value);
                trial = null;
                fsb = new FastStringBuffer(16);
                DecimalValue.decimalToString(initial, fsb);
                s = fsb.toString();
                start = s.charAt(0) == '-' ? 1 : 0;
                p = s.indexOf(".");
                i = s.lastIndexOf(zeros);
                if (i <= 0) break block11;
                if (p < 0 || i < p) {
                    sb = new FastStringBuffer(s.length());
                    sb.append(s.substring(0, i));
                    n = i;
                    while (n < s.length()) {
                        sb.append(s.charAt(n) == '.' ? '.' : '0');
                        ++n;
                    }
                    trial = new BigDecimal(sb.toString());
                } else {
                    trial = new BigDecimal(s.substring(0, i));
                }
                break block12;
            }
            i = s.indexOf(nines);
            if (i < 0) break block12;
            if (i != start) ** GOTO lbl41
            sb = new FastStringBuffer(s.length() + 1);
            if (start == 1) {
                sb.append('-');
            }
            sb.append('1');
            n = start;
            while (n < s.length()) {
                sb.append(s.charAt(n) == '.' ? '.' : '0');
                ++n;
            }
            trial = new BigDecimal(sb.toString());
            break block12;
lbl-1000:
            // 1 sources

            {
                --i;
lbl41:
                // 2 sources

                ** while (i >= 0 && (s.charAt((int)i) == '9' || s.charAt((int)i) == '.'))
            }
lbl42:
            // 1 sources

            if (i < 0 || s.charAt(i) == '-') {
                return initial;
            }
            if (p < 0 || i < p) {
                sb = new FastStringBuffer(s.length());
                sb.append(s.substring(0, i));
                sb.append((char)(s.charAt(i) + '\u0001'));
                n = i;
                while (n < s.length()) {
                    sb.append(s.charAt(n) == '.' ? '.' : '0');
                    ++n;
                }
                trial = new BigDecimal(sb.toString());
            } else {
                s2 = String.valueOf(s.substring(0, i)) + (char)(s.charAt(i) + '\u0001');
                trial = new BigDecimal(s2);
            }
        }
        if (trial != null && (precision == 1 ? (double)trial.floatValue() == value : trial.doubleValue() == value)) {
            return trial;
        }
        return initial;
    }

    private static CharSequence unicodeChar(int ch) {
        if (ch < 65536) {
            return "" + (char)ch;
        }
        char[] sb = new char[]{(char)((ch -= 65536) / 1024 + 55296), (char)(ch % 1024 + 56320)};
        return new CharSlice(sb, 0, 2);
    }

    private static int[] insert(int[] array, int used, int value, int position) {
        if (used + 1 > array.length) {
            int[] a2 = new int[used + 10];
            System.arraycopy(array, 0, a2, 0, used);
            array = a2;
        }
        int i = used - 1;
        while (i >= position) {
            array[i + 1] = array[i];
            --i;
        }
        array[position] = value;
        return array;
    }

    private class SubPicture
    implements Serializable {
        int minWholePartSize = 0;
        int maxWholePartSize = 0;
        int minFractionPartSize = 0;
        int maxFractionPartSize = 0;
        boolean isPercent = false;
        boolean isPerMille = false;
        String prefix = "";
        String suffix = "";
        int[] wholePartGroupingPositions = null;
        int[] fractionalPartGroupingPositions = null;

        public SubPicture(int[] pic, DecimalSymbols dfs) throws XPathException {
            int i;
            int n;
            int percentSign = dfs.percent;
            int perMilleSign = dfs.permill;
            int decimalSeparator = dfs.decimalSeparator;
            int groupingSeparator = dfs.groupingSeparator;
            int digitSign = dfs.digit;
            int zeroDigit = dfs.zeroDigit;
            ArrayList<Integer> wholePartPositions = null;
            ArrayList<Integer> fractionalPartPositions = null;
            boolean foundDigit = false;
            boolean foundDecimalSeparator = false;
            int i2 = 0;
            while (i2 < pic.length) {
                if (pic[i2] == digitSign || pic[i2] == zeroDigit) {
                    foundDigit = true;
                    break;
                }
                ++i2;
            }
            if (!foundDigit) {
                FormatNumber.this.grumble("subpicture contains no digit or zero-digit sign");
            }
            int phase = 0;
            int i3 = 0;
            while (i3 < pic.length) {
                int c = pic[i3];
                if (c == percentSign || c == perMilleSign) {
                    if (this.isPercent || this.isPerMille) {
                        FormatNumber.this.grumble("Cannot have more than one percent or per-mille character in a sub-picture");
                    }
                    this.isPercent = c == percentSign;
                    this.isPerMille = c == perMilleSign;
                    switch (phase) {
                        case 0: {
                            this.prefix = String.valueOf(this.prefix) + FormatNumber.unicodeChar(c);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            phase = 5;
                            this.suffix = String.valueOf(this.suffix) + FormatNumber.unicodeChar(c);
                        }
                    }
                } else if (c == digitSign) {
                    switch (phase) {
                        case 0: 
                        case 1: {
                            phase = 1;
                            ++this.maxWholePartSize;
                            break;
                        }
                        case 2: {
                            FormatNumber.this.grumble("Digit sign must not appear after a zero-digit sign in the integer part of a sub-picture");
                            break;
                        }
                        case 3: 
                        case 4: {
                            phase = 4;
                            ++this.maxFractionPartSize;
                            break;
                        }
                        case 5: {
                            FormatNumber.this.grumble("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                } else if (c == zeroDigit) {
                    switch (phase) {
                        case 0: 
                        case 1: 
                        case 2: {
                            phase = 2;
                            ++this.minWholePartSize;
                            ++this.maxWholePartSize;
                            break;
                        }
                        case 3: {
                            ++this.minFractionPartSize;
                            ++this.maxFractionPartSize;
                            break;
                        }
                        case 4: {
                            FormatNumber.this.grumble("Zero digit sign must not appear after a digit sign in the fractional part of a sub-picture");
                            break;
                        }
                        case 5: {
                            FormatNumber.this.grumble("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                } else if (c == decimalSeparator) {
                    switch (phase) {
                        case 0: 
                        case 1: 
                        case 2: {
                            phase = 3;
                            foundDecimalSeparator = true;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            if (foundDecimalSeparator) {
                                FormatNumber.this.grumble("There must only be one decimal separator in a sub-picture");
                                break;
                            }
                            FormatNumber.this.grumble("Decimal separator cannot come after a character in the suffix");
                        }
                    }
                } else if (c == groupingSeparator) {
                    switch (phase) {
                        case 0: 
                        case 1: 
                        case 2: {
                            if (wholePartPositions == null) {
                                wholePartPositions = new ArrayList<Integer>(3);
                            }
                            wholePartPositions.add(new Integer(this.maxWholePartSize));
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (this.maxFractionPartSize == 0) {
                                FormatNumber.this.grumble("Grouping separator cannot be adjacent to decimal separator");
                            }
                            if (fractionalPartPositions == null) {
                                fractionalPartPositions = new ArrayList<Integer>(3);
                            }
                            fractionalPartPositions.add(new Integer(this.maxFractionPartSize));
                            break;
                        }
                        case 5: {
                            FormatNumber.this.grumble("Grouping separator found in suffix of sub-picture");
                        }
                    }
                } else {
                    switch (phase) {
                        case 0: {
                            this.prefix = String.valueOf(this.prefix) + FormatNumber.unicodeChar(c);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            phase = 5;
                            this.suffix = String.valueOf(this.suffix) + FormatNumber.unicodeChar(c);
                        }
                    }
                }
                ++i3;
            }
            if (this.minWholePartSize == 0 && !foundDecimalSeparator) {
                this.minWholePartSize = 1;
            }
            if (wholePartPositions != null) {
                n = wholePartPositions.size();
                this.wholePartGroupingPositions = new int[n];
                i = 0;
                while (i < n) {
                    this.wholePartGroupingPositions[i] = this.maxWholePartSize - (Integer)wholePartPositions.get(n - i - 1);
                    ++i;
                }
                if (n > 1) {
                    boolean regular = true;
                    int first = this.wholePartGroupingPositions[0];
                    int i4 = 1;
                    while (i4 < n) {
                        if (this.wholePartGroupingPositions[i4] != i4 * first) {
                            regular = false;
                            break;
                        }
                        ++i4;
                    }
                    if (regular) {
                        this.wholePartGroupingPositions = new int[1];
                        this.wholePartGroupingPositions[0] = first;
                    }
                }
                if (this.wholePartGroupingPositions[0] == 0) {
                    FormatNumber.this.grumble("Cannot have a grouping separator adjacent to the decimal separator");
                }
            }
            if (fractionalPartPositions != null) {
                n = fractionalPartPositions.size();
                this.fractionalPartGroupingPositions = new int[n];
                i = 0;
                while (i < n) {
                    this.fractionalPartGroupingPositions[i] = (Integer)fractionalPartPositions.get(i);
                    ++i;
                }
            }
        }

        public CharSequence format(NumericValue value, DecimalSymbols dfs, String minusSign) {
            int i;
            int p;
            if (value.isNaN()) {
                return dfs.NaN;
            }
            if ((value instanceof DoubleValue || value instanceof FloatValue) && Double.isInfinite(value.getDoubleValue())) {
                return String.valueOf(minusSign) + this.prefix + dfs.infinity + this.suffix;
            }
            int multiplier = 1;
            if (this.isPercent) {
                multiplier = 100;
            } else if (this.isPerMille) {
                multiplier = 1000;
            }
            if (multiplier != 1) {
                try {
                    value = (NumericValue)ArithmeticExpression.compute(value, 2, new Int64Value(multiplier), null);
                }
                catch (XPathException xPathException) {
                    value = new DoubleValue(value.getDoubleValue() * (double)multiplier);
                }
            }
            FastStringBuffer sb = new FastStringBuffer(16);
            if (value instanceof DoubleValue || value instanceof FloatValue) {
                BigDecimal dec = FormatNumber.adjustToDecimal(value.getDoubleValue(), 2);
                this.formatDecimal(dec, sb);
            } else if (value instanceof Int64Value || value instanceof BigIntegerValue) {
                this.formatInteger(value, sb);
            } else if (value instanceof DecimalValue) {
                this.formatDecimal(((DecimalValue)value).getDecimalValue(), sb);
            }
            int[] ib = StringValue.expand(sb);
            int ibused = ib.length;
            int point = sb.indexOf('.');
            if (point == -1) {
                point = sb.length();
            } else {
                ib[point] = dfs.decimalSeparator;
                if (this.maxFractionPartSize == 0) {
                    --ibused;
                }
            }
            if (dfs.zeroDigit != 48) {
                int newZero = dfs.zeroDigit;
                int i2 = 0;
                while (i2 < ibused) {
                    int c = ib[i2];
                    if (c >= 48 && c <= 57) {
                        ib[i2] = c - 48 + newZero;
                    }
                    ++i2;
                }
            }
            if (this.wholePartGroupingPositions != null) {
                if (this.wholePartGroupingPositions.length == 1) {
                    int g = this.wholePartGroupingPositions[0];
                    p = point - g;
                    while (p > 0) {
                        ib = FormatNumber.insert(ib, ibused++, dfs.groupingSeparator, p);
                        p -= g;
                    }
                } else {
                    i = 0;
                    while (i < this.wholePartGroupingPositions.length) {
                        p = point - this.wholePartGroupingPositions[i];
                        if (p > 0) {
                            ib = FormatNumber.insert(ib, ibused++, dfs.groupingSeparator, p);
                        }
                        ++i;
                    }
                }
            }
            if (this.fractionalPartGroupingPositions != null) {
                i = 0;
                while (i < this.fractionalPartGroupingPositions.length) {
                    p = point + 1 + this.fractionalPartGroupingPositions[i] + i;
                    if (p >= ibused - 1) break;
                    ib = FormatNumber.insert(ib, ibused++, dfs.groupingSeparator, p);
                    ++i;
                }
            }
            FastStringBuffer res = new FastStringBuffer(this.prefix.length() + minusSign.length() + this.suffix.length() + ibused);
            res.append(minusSign);
            res.append(this.prefix);
            res.append(StringValue.contract(ib, ibused));
            res.append(this.suffix);
            return res;
        }

        private void formatDecimal(BigDecimal dval, FastStringBuffer fsb) {
            int intDigits;
            dval = dval.setScale(this.maxFractionPartSize, 6);
            DecimalValue.decimalToString(dval, fsb);
            int point = fsb.indexOf('.');
            if (point >= 0) {
                int zz = this.maxFractionPartSize - this.minFractionPartSize;
                while (zz > 0) {
                    if (fsb.charAt(fsb.length() - 1) != '0') break;
                    fsb.setLength(fsb.length() - 1);
                    --zz;
                }
                intDigits = point;
                if (fsb.charAt(fsb.length() - 1) == '.') {
                    fsb.setLength(fsb.length() - 1);
                }
            } else {
                intDigits = fsb.length();
                if (this.minFractionPartSize > 0) {
                    fsb.append('.');
                    int i = 0;
                    while (i < this.minFractionPartSize) {
                        fsb.append('0');
                        ++i;
                    }
                }
            }
            if (this.minWholePartSize == 0 && intDigits == 1 && fsb.charAt(0) == '0') {
                fsb.removeCharAt(0);
            } else {
                fsb.prependRepeated('0', this.minWholePartSize - intDigits);
            }
        }

        private void formatInteger(NumericValue value, FastStringBuffer fsb) {
            fsb.append(value.getStringValueCS());
            int leadingZeroes = this.minWholePartSize - fsb.length();
            fsb.prependRepeated('0', leadingZeroes);
            if (this.minFractionPartSize != 0) {
                fsb.append('.');
                int i = 0;
                while (i < this.minFractionPartSize) {
                    fsb.append('0');
                    ++i;
                }
            }
        }
    }
}

