/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.trans.XPathException;

public class CurrentGroup
extends SystemFunction {
    public static final int CURRENT_GROUP = 0;
    public static final int CURRENT_GROUPING_KEY = 1;

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        if (this.operation == 1) {
            GroupIterator gi = c.getCurrentGroupIterator();
            if (gi == null) {
                return null;
            }
            return gi.getCurrentGroupingKey();
        }
        return super.evaluateItem(c);
    }

    @Override
    public SequenceIterator iterate(XPathContext c) throws XPathException {
        if (this.operation == 0) {
            GroupIterator gi = c.getCurrentGroupIterator();
            if (gi == null) {
                return EmptyIterator.getInstance();
            }
            return gi.iterateCurrentGroup();
        }
        return super.iterate(c);
    }

    @Override
    public int getIntrinsicDependencies() {
        return 32;
    }
}

