/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.RuleBasedCollator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.NamedCollation;
import net.sf.saxon.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.sort.SubstringMatcher;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class Contains
extends CollatingFunction {
    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        StringValue arg1 = (StringValue)this.argument[1].evaluateItem(context);
        if (arg1 == null || arg1.isZeroLength()) {
            return true;
        }
        StringValue arg0 = (StringValue)this.argument[0].evaluateItem(context);
        if (arg0 == null || arg0.isZeroLength()) {
            return false;
        }
        String s0 = arg0.getStringValue();
        String s1 = arg1.getStringValue();
        if (this.stringCollator instanceof CodepointCollator) {
            return s0.indexOf(s1, 0) >= 0;
        }
        StringCollator collator = this.getCollator(2, context);
        if (collator instanceof NamedCollation && ((NamedCollation)collator).getCollation() instanceof RuleBasedCollator) {
            collator = new RuleBasedSubstringMatcher((RuleBasedCollator)((NamedCollation)collator).getCollation());
        }
        if (collator instanceof SubstringMatcher) {
            return ((SubstringMatcher)collator).contains(s0, s1);
        }
        this.dynamicError("The collation requested for " + this.getDisplayName() + " does not support substring matching", "FOCH0004", context);
        return false;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }
}

