/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public abstract class CollatingFunction
extends SystemFunction {
    protected StringCollator stringCollator = null;
    private String absoluteCollationURI = null;
    private URI expressionBaseURI = null;

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.stringCollator == null) {
            StaticContext env = visitor.getStaticContext();
            this.saveBaseURI(env, false);
            this.preEvaluateCollation(env);
        }
        super.checkArguments(visitor);
    }

    private void saveBaseURI(StaticContext env, boolean fail) throws XPathException {
        block7: {
            if (this.expressionBaseURI == null) {
                String base = null;
                try {
                    base = env.getBaseURI();
                    if (base == null) {
                        base = this.getCurrentDirectory();
                    }
                    if (base != null) {
                        this.expressionBaseURI = new URI(base);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    String esc = EscapeURI.iriToUri(base).toString();
                    try {
                        this.expressionBaseURI = new URI(esc);
                    }
                    catch (URISyntaxException uRISyntaxException2) {
                        this.expressionBaseURI = null;
                    }
                    if (this.expressionBaseURI != null || !fail) break block7;
                    XPathException err = new XPathException("The base URI " + Err.wrap(env.getBaseURI(), 7) + " is not a valid URI");
                    err.setLocator(this);
                    throw err;
                }
            }
        }
    }

    public URI getExpressionBaseURI() {
        return this.expressionBaseURI;
    }

    public StringCollator getStringCollator() {
        return this.stringCollator;
    }

    public String getAbsoluteCollationURI() {
        return this.absoluteCollationURI;
    }

    private String getCurrentDirectory() {
        String dir;
        try {
            dir = System.getProperty("user.dir");
        }
        catch (Exception exception) {
            return null;
        }
        if (!dir.endsWith("/")) {
            dir = String.valueOf(dir) + '/';
        }
        URI currentDirectoryURL = new File(dir).toURI();
        return currentDirectoryURL.toString();
    }

    private void preEvaluateCollation(StaticContext env) throws XPathException {
        if (this.getNumberOfArguments() == this.getDetails().maxArguments) {
            Value collationVal;
            Expression collationExp = this.argument[this.getNumberOfArguments() - 1];
            Value value = collationVal = collationExp instanceof Literal ? ((Literal)collationExp).getValue() : null;
            if (collationVal instanceof AtomicValue) {
                String collationName = collationVal.getStringValue();
                try {
                    URI collationURI = new URI(collationName);
                    if (!collationURI.isAbsolute()) {
                        this.saveBaseURI(env, true);
                        if (this.expressionBaseURI == null) {
                            XPathException err = new XPathException("The collation name is a relative URI, but the base URI is unknown");
                            err.setErrorCode("XPST0001");
                            err.setIsStaticError(true);
                            err.setLocator(this);
                            throw err;
                        }
                        URI base = this.expressionBaseURI;
                        collationURI = base.resolve(collationURI);
                        collationName = collationURI.toString();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    XPathException err = new XPathException("Collation name '" + collationName + "' is not a valid URI");
                    err.setErrorCode("FOCH0002");
                    err.setIsStaticError(true);
                    err.setLocator(this);
                    throw err;
                }
                StringCollator comp = env.getCollation(collationName);
                if (comp == null) {
                    XPathException err = new XPathException("Unknown collation " + Err.wrap(collationName, 7));
                    err.setErrorCode("FOCH0002");
                    err.setIsStaticError(true);
                    err.setLocator(this);
                    throw err;
                }
                this.stringCollator = comp;
            }
        } else {
            String uri = env.getDefaultCollationName();
            this.stringCollator = env.getCollation(uri);
        }
    }

    @Override
    public Expression copy() {
        CollatingFunction d = (CollatingFunction)super.copy();
        d.expressionBaseURI = this.expressionBaseURI;
        d.absoluteCollationURI = this.absoluteCollationURI;
        d.stringCollator = this.stringCollator;
        return d;
    }

    protected GenericAtomicComparer getAtomicComparer(int arg, XPathContext context) throws XPathException {
        return new GenericAtomicComparer(this.getCollator(arg, context), context);
    }

    protected StringCollator getCollator(int arg, XPathContext context) throws XPathException {
        if (this.stringCollator != null) {
            return this.stringCollator;
        }
        int numargs = this.argument.length;
        if (numargs > arg) {
            AtomicValue av = (AtomicValue)this.argument[arg].evaluateItem(context);
            StringValue collationValue = (StringValue)av;
            String collationName = collationValue.getStringValue();
            try {
                URI collationURI = new URI(collationName);
                if (!collationURI.isAbsolute()) {
                    if (this.expressionBaseURI == null) {
                        XPathException err = new XPathException("Cannot resolve relative collation URI '" + collationName + "': unknown or invalid base URI");
                        err.setErrorCode("FOCH0002");
                        err.setXPathContext(context);
                        err.setLocator(this);
                        throw err;
                    }
                    collationURI = this.expressionBaseURI.resolve(collationURI);
                    collationName = collationURI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                XPathException err = new XPathException("Collation name '" + collationName + "' is not a valid URI");
                err.setErrorCode("FOCH0002");
                err.setXPathContext(context);
                err.setLocator(this);
                throw err;
            }
            return context.getCollation(collationName);
        }
        return CodepointCollator.getInstance();
    }
}

