/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicMappingExpression;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class UntypedAtomicConverter
extends UnaryExpression
implements MappingExpression {
    private AtomicType requiredItemType;
    private boolean allConverted;
    private boolean singleton = false;
    private RoleLocator role;

    public UntypedAtomicConverter(Expression sequence, AtomicType requiredItemType, boolean allConverted, RoleLocator role) {
        super(sequence);
        this.requiredItemType = requiredItemType;
        this.allConverted = allConverted;
        this.role = role;
        ExpressionTool.copyLocationInfo(sequence, this);
    }

    public ItemType getRequiredItemType() {
        return this.requiredItemType;
    }

    public boolean areAllItemsConverted() {
        return this.allConverted;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        ItemType it = this.operand.getItemType(th);
        boolean bl = this.singleton = it.isAtomicType() && !Cardinality.allowsMany(this.operand.getCardinality());
        if (this.allConverted) {
            return this.requiredItemType;
        }
        return Type.getCommonSuperType(this.requiredItemType, this.operand.getItemType(th), th);
    }

    @Override
    public int computeCardinality() {
        if (this.singleton) {
            return 24576;
        }
        return super.computeCardinality();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.allConverted && this.requiredItemType.isNamespaceSensitive()) {
            XPathException err = new XPathException("Cannot convert untypedAtomic values to QNames or NOTATIONs");
            err.setErrorCode("XPTY0004");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        if (this.operand instanceof Literal) {
            return Literal.makeLiteral(((Value)SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()))).reduce());
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType type = this.operand.getItemType(th);
        if (type instanceof NodeTest) {
            return this;
        }
        if (this.operand instanceof Atomizer && type.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && this.requiredItemType == BuiltInAtomicType.STRING && ((Atomizer)this.operand).getBaseExpression().getItemType(th) instanceof NodeTest) {
            Expression nodeExp = ((Atomizer)this.operand).getBaseExpression();
            if (nodeExp.getCardinality() != 16384) {
                SystemFunction fn = (SystemFunction)SystemFunction.makeSystemFunction("string", new Expression[]{new ContextItemExpression()});
                fn.setContainer(this.getContainer());
                AtomicMappingExpression map = new AtomicMappingExpression(nodeExp, fn);
                map.setContainer(this.getContainer());
                return map;
            }
            SystemFunction fn = (SystemFunction)SystemFunction.makeSystemFunction("string", new Expression[]{nodeExp});
            fn.setContainer(this.getContainer());
            return fn;
        }
        if (type.equals(BuiltInAtomicType.ANY_ATOMIC) || type instanceof AnyItemType || type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return this;
        }
        return this.operand;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000 | 0x2000000;
    }

    @Override
    public Expression copy() {
        return new UntypedAtomicConverter(this.getBaseExpression().copy(), this.requiredItemType, this.allConverted, this.role);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        return this.getMappingIterator(base, context);
    }

    @Override
    public SequenceIterator getMappingIterator(SequenceIterator base, final XPathContext context) throws XPathException {
        ItemMappingFunction converter = new ItemMappingFunction(){

            @Override
            public Item map(Item item) throws XPathException {
                if (item instanceof UntypedAtomicValue) {
                    ConversionResult val = ((UntypedAtomicValue)item).convert(UntypedAtomicConverter.this.requiredItemType, true, context);
                    if (val instanceof ValidationFailure) {
                        String msg = UntypedAtomicConverter.this.role.composeRequiredMessage(UntypedAtomicConverter.this.requiredItemType, context.getNamePool());
                        msg = String.valueOf(msg) + ". " + ((ValidationFailure)val).getMessage();
                        XPathException err = new XPathException(msg);
                        err.setErrorCode(UntypedAtomicConverter.this.role.getErrorCode());
                        err.setLocator(UntypedAtomicConverter.this);
                        throw err;
                    }
                    return (AtomicValue)val;
                }
                return item;
            }
        };
        return new ItemMappingIterator(base, converter, true);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        if (item instanceof UntypedAtomicValue) {
            ConversionResult val = ((UntypedAtomicValue)item).convert(this.requiredItemType, true, context);
            if (val instanceof ValidationFailure) {
                String msg = this.role.composeRequiredMessage(this.requiredItemType, context.getNamePool());
                msg = String.valueOf(msg) + ". " + ((ValidationFailure)val).getMessage();
                XPathException err = new XPathException(msg);
                err.setErrorCode(this.role.getErrorCode());
                err.setLocator(this);
                throw err;
            }
            return (AtomicValue)val;
        }
        return item;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("convertUntypedAtomic");
        out.emitAttribute("to", this.requiredItemType.toString(out.getConfiguration().getNamePool()));
        out.emitAttribute("all", this.allConverted ? "true" : "false");
        this.operand.explain(out);
        out.endElement();
    }

    @Override
    protected String displayOperator(Configuration config) {
        return "convert untyped atomic items to " + this.requiredItemType.toString(config.getNamePool());
    }
}

