/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public class PathMap {
    private List<PathMapRoot> pathMapRoots = new ArrayList<PathMapRoot>();
    private HashMap<Binding, PathMapNodeSet> pathsForVariables = new HashMap();

    public PathMap(Expression exp) {
        PathMapNodeSet finalNodes = exp.addToPathMap(this, null);
        if (finalNodes != null) {
            for (PathMapNode node : finalNodes) {
                node.setReturnable(true);
            }
        }
    }

    public PathMapRoot makeNewRoot(Expression exp) {
        int i = 0;
        while (i < this.pathMapRoots.size()) {
            PathMapRoot r = this.pathMapRoots.get(i);
            if (exp.equals(r.getRootExpression())) {
                return r;
            }
            ++i;
        }
        PathMapRoot root = new PathMapRoot(exp);
        this.pathMapRoots.add(root);
        return root;
    }

    public PathMapRoot[] getPathMapRoots() {
        return this.pathMapRoots.toArray(new PathMapRoot[this.pathMapRoots.size()]);
    }

    public void registerPathForVariable(Binding binding, PathMapNodeSet nodeset) {
        this.pathsForVariables.put(binding, nodeset);
    }

    public PathMapNodeSet getPathForVariable(Binding binding) {
        return this.pathsForVariables.get(binding);
    }

    public PathMapRoot getContextRoot() {
        PathMapRoot[] roots = this.getPathMapRoots();
        PathMapRoot contextRoot = null;
        int r = 0;
        while (r < roots.length) {
            PathMapRoot newRoot = this.reduceToDownwardsAxes(roots[r]);
            if (newRoot.getRootExpression() instanceof RootExpression) {
                if (contextRoot != null) {
                    throw new IllegalStateException("More than one context document root found in path map");
                }
                contextRoot = newRoot;
            }
            ++r;
        }
        return contextRoot;
    }

    public PathMapRoot getRootForDocument(String requiredUri) {
        PathMapRoot[] roots = this.getPathMapRoots();
        PathMapRoot requiredRoot = null;
        int r = 0;
        while (r < roots.length) {
            block10: {
                String baseUri;
                Expression exp;
                PathMapRoot newRoot;
                block9: {
                    block8: {
                        newRoot = this.reduceToDownwardsAxes(roots[r]);
                        exp = newRoot.getRootExpression();
                        baseUri = null;
                        if (!(exp instanceof Doc)) break block8;
                        baseUri = ((Doc)exp).getStaticBaseURI();
                        break block9;
                    }
                    if (!(exp instanceof Document)) break block10;
                    baseUri = ((Document)exp).getStaticBaseURI();
                }
                Expression arg = ((SystemFunction)exp).getArguments()[0];
                String suppliedUri = null;
                if (arg instanceof Literal) {
                    try {
                        String argValue = ((Literal)arg).getValue().getStringValue();
                        suppliedUri = baseUri == null ? (new URI(argValue).isAbsolute() ? argValue : null) : ResolveURI.makeAbsolute(argValue, baseUri).toString();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        suppliedUri = null;
                    }
                    catch (XPathException xPathException) {
                        suppliedUri = null;
                    }
                }
                if (requiredUri.equals(suppliedUri)) {
                    if (requiredRoot != null) {
                        throw new IllegalStateException("More than one document root found in path map for " + requiredUri);
                    }
                    requiredRoot = newRoot;
                }
            }
            ++r;
        }
        return requiredRoot;
    }

    public PathMapRoot reduceToDownwardsAxes(PathMapRoot root) {
        if (root.isDownwardsOnly) {
            return root;
        }
        PathMapRoot newRoot = root;
        if (root.getRootExpression() instanceof ContextItemExpression) {
            RootExpression slash = new RootExpression();
            slash.setContainer(root.getRootExpression().getContainer());
            newRoot = this.makeNewRoot(slash);
            int i = root.arcs.size() - 1;
            while (i >= 0) {
                PathMapArc arc = (PathMapArc)root.arcs.get(i);
                byte axis = arc.getStep().getAxis();
                switch (axis) {
                    case 2: 
                    case 8: {
                        AxisExpression newStep = new AxisExpression(4, NodeKindTest.ELEMENT);
                        PathMapNode newTarget = new PathMapNode(null, null);
                        newTarget.arcs.add(arc);
                        newRoot.createArc(newStep, newTarget);
                        break;
                    }
                    default: {
                        AxisExpression newStep = new AxisExpression(5, arc.getStep().getNodeTest());
                        newRoot.createArc(newStep, arc.getTarget());
                    }
                }
                --i;
            }
            i = 0;
            while (i < this.pathMapRoots.size()) {
                if (this.pathMapRoots.get(i) == root) {
                    this.pathMapRoots.remove(i);
                    break;
                }
                ++i;
            }
        }
        Stack<PathMapNode> nodeStack = new Stack<PathMapNode>();
        nodeStack.push(newRoot);
        this.reduceToDownwardsAxes(newRoot, nodeStack);
        newRoot.isDownwardsOnly = true;
        return newRoot;
    }

    private void reduceToDownwardsAxes(PathMapRoot root, Stack<PathMapNode> nodeStack) {
        PathMapNode node = nodeStack.peek();
        if (node.hasUnknownDependencies()) {
            root.setHasUnknownDependencies();
        }
        int i = 0;
        while (i < node.arcs.size()) {
            nodeStack.push(node.arcs.get(i).getTarget());
            this.reduceToDownwardsAxes(root, nodeStack);
            nodeStack.pop();
            ++i;
        }
        i = node.arcs.size() - 1;
        while (i >= 0) {
            PathMapArc thisArc = node.arcs.get(i);
            AxisExpression axisStep = thisArc.getStep();
            PathMapNode grandParent = nodeStack.size() < 2 ? null : (PathMapNode)nodeStack.get(nodeStack.size() - 2);
            byte lastAxis = -1;
            if (grandParent != null) {
                for (PathMapArc arc : grandParent.arcs) {
                    if (arc.getTarget() != node) continue;
                    lastAxis = arc.getStep().getAxis();
                }
            }
            switch (axisStep.getAxis()) {
                case 1: 
                case 5: {
                    if (axisStep.getNodeTest() == NodeKindTest.DOCUMENT) {
                        node.arcs.remove(i);
                        Iterator<PathMapArc> iter = thisArc.getTarget().arcs.iterator();
                        while (iter.hasNext()) {
                            root.arcs.add(iter.next());
                        }
                        break;
                    }
                }
                case 0: 
                case 6: 
                case 10: {
                    if (axisStep.getAxis() == 5) break;
                    AxisExpression newStep = new AxisExpression(5, axisStep.getNodeTest());
                    newStep.setContainer(axisStep.getContainer());
                    root.createArc(newStep, thisArc.getTarget());
                    node.arcs.remove(i);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    break;
                }
                case 7: 
                case 11: {
                    AxisExpression newStep;
                    if (grandParent != null) {
                        newStep = new AxisExpression(lastAxis, axisStep.getNodeTest());
                        newStep.setContainer(axisStep.getContainer());
                        grandParent.createArc(newStep, thisArc.getTarget());
                        node.arcs.remove(i);
                        break;
                    }
                    newStep = new AxisExpression(3, axisStep.getNodeTest());
                    newStep.setContainer(axisStep.getContainer());
                    root.createArc(newStep, thisArc.getTarget());
                    node.arcs.remove(i);
                    break;
                }
                case 9: {
                    AxisExpression newStep;
                    if (lastAxis == 3 || lastAxis == 2 || lastAxis == 8) {
                        if (node.isReturnable()) {
                            grandParent.setReturnable(true);
                        }
                        PathMapNode target = thisArc.getTarget();
                        int a = 0;
                        while (a < target.arcs.size()) {
                            grandParent.arcs.add(target.arcs.get(a));
                            ++a;
                        }
                        node.arcs.remove(i);
                        break;
                    }
                    if (lastAxis == 4) {
                        newStep = new AxisExpression(5, axisStep.getNodeTest());
                        newStep.setContainer(axisStep.getContainer());
                        if (thisArc.getTarget().arcs.isEmpty()) {
                            grandParent.createArc(newStep);
                        } else {
                            grandParent.createArc(newStep, thisArc.getTarget());
                        }
                        node.arcs.remove(i);
                        break;
                    }
                    newStep = new AxisExpression(5, axisStep.getNodeTest());
                    newStep.setContainer(axisStep.getContainer());
                    if (thisArc.getTarget().arcs.isEmpty()) {
                        root.createArc(newStep);
                    } else {
                        root.createArc(newStep, thisArc.getTarget());
                    }
                    node.arcs.remove(i);
                    break;
                }
                case 12: {
                    node.arcs.remove(i);
                }
            }
            --i;
        }
    }

    public void diagnosticDump(PrintStream out) {
        int i = 0;
        while (i < this.pathMapRoots.size()) {
            out.println("\nROOT EXPRESSION " + i);
            PathMapRoot mapRoot = this.pathMapRoots.get(i);
            if (mapRoot.hasUnknownDependencies()) {
                out.println("  -- has unknown dependencies --");
            }
            Expression exp = mapRoot.rootExpression;
            exp.explain(out);
            out.println("\nTREE FOR EXPRESSION " + i);
            this.showArcs(out, mapRoot, 2);
            ++i;
        }
    }

    private void showArcs(PrintStream out, PathMapNode node, int indent) {
        String pad = "                                           ".substring(0, indent);
        List<PathMapArc> arcs = node.arcs;
        int i = 0;
        while (i < arcs.size()) {
            PathMapArc arc = arcs.get(i);
            out.println(String.valueOf(pad) + arc.step + (arc.target.isAtomized() ? " @" : "") + (arc.target.isReturnable() ? " #" : "") + (arc.target.hasUnknownDependencies() ? " ...??" : ""));
            this.showArcs(out, arc.target, indent + 2);
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        Expression exp;
        Configuration config = new Configuration();
        if (args[0].equals("xpath")) {
            XPathEvaluator xpath = new XPathEvaluator(config);
            XPathExpression xpexp = xpath.createExpression(args[1]);
            exp = xpexp.getInternalExpression();
        } else if (args[0].equals("xquery")) {
            StaticQueryContext sqc = config.newStaticQueryContext();
            sqc.setBaseURI(new File(args[1]).toURI().toString());
            XQueryExpression xqe = sqc.compileQuery(new FileReader(args[1]));
            exp = xqe.getExpression();
        } else {
            throw new IllegalArgumentException("first argument must be xpath or xquery");
        }
        exp.explain(System.err);
        PathMap initialPath = new PathMap(exp);
        initialPath.diagnosticDump(System.err);
        PathMapRoot[] roots = initialPath.getPathMapRoots();
        int i = 0;
        while (i < roots.length) {
            initialPath.reduceToDownwardsAxes(roots[i]);
            ++i;
        }
        System.err.println("AFTER REDUCTION:");
        initialPath.diagnosticDump(System.err);
    }

    public static class PathMapArc {
        private PathMapNode target;
        private AxisExpression step;

        private PathMapArc(AxisExpression step, PathMapNode target) {
            this.step = step;
            this.target = target;
        }

        public AxisExpression getStep() {
            return this.step;
        }

        public PathMapNode getTarget() {
            return this.target;
        }
    }

    public static class PathMapNode {
        List<PathMapArc> arcs = new ArrayList<PathMapArc>();
        private boolean returnable;
        private boolean atomized;
        private boolean hasUnknownDependencies;

        private PathMapNode() {
        }

        public PathMapNode createArc(AxisExpression step) {
            int i = 0;
            while (i < this.arcs.size()) {
                PathMapArc a = this.arcs.get(i);
                if (a.getStep().equals(step)) {
                    return a.getTarget();
                }
                ++i;
            }
            PathMapNode target = new PathMapNode();
            PathMapArc arc = new PathMapArc(step, target);
            this.arcs.add(arc);
            return target;
        }

        public void createArc(AxisExpression step, PathMapNode target) {
            int i = 0;
            while (i < this.arcs.size()) {
                PathMapArc a = this.arcs.get(i);
                if (a.getStep().equals(step) && a.getTarget() == target) {
                    a.getTarget().setReturnable(a.getTarget().isReturnable() || target.isReturnable());
                    if (target.isAtomized()) {
                        a.getTarget().setAtomized();
                    }
                    return;
                }
                ++i;
            }
            PathMapArc arc = new PathMapArc(step, target);
            this.arcs.add(arc);
        }

        public PathMapArc[] getArcs() {
            return this.arcs.toArray(new PathMapArc[this.arcs.size()]);
        }

        public void setReturnable(boolean returnable) {
            this.returnable = returnable;
        }

        public boolean isReturnable() {
            return this.returnable;
        }

        public void setAtomized() {
            this.atomized = true;
        }

        public boolean isAtomized() {
            return this.atomized;
        }

        public void setHasUnknownDependencies() {
            this.hasUnknownDependencies = true;
        }

        public boolean hasUnknownDependencies() {
            return this.hasUnknownDependencies;
        }

        /* synthetic */ PathMapNode(PathMapNode pathMapNode, PathMapNode pathMapNode2) {
            this();
        }
    }

    public static class PathMapNodeSet
    extends HashSet {
        public PathMapNodeSet() {
        }

        public PathMapNodeSet(PathMapNode singleton) {
            this.add(singleton);
        }

        public PathMapNodeSet createArc(AxisExpression step) {
            PathMapNodeSet targetSet = new PathMapNodeSet();
            for (PathMapNode node : this) {
                targetSet.add(node.createArc(step));
            }
            return targetSet;
        }

        public void addNodeSet(PathMapNodeSet nodes) {
            if (nodes != null) {
                for (PathMapNode node : nodes) {
                    this.add(node);
                }
            }
        }

        public void setAtomized() {
            for (PathMapNode node : this) {
                node.setAtomized();
            }
        }

        public void addDescendants() {
            for (PathMapNode node : this) {
                AxisExpression down = new AxisExpression(4, AnyNodeTest.getInstance());
                node.createArc(down);
            }
        }

        public void setHasUnknownDependencies() {
            for (PathMapNode node : this) {
                node.setHasUnknownDependencies();
            }
        }
    }

    public static class PathMapRoot
    extends PathMapNode {
        private Expression rootExpression;
        private boolean isDownwardsOnly;

        private PathMapRoot(Expression root) {
            this.rootExpression = root;
        }

        public Expression getRootExpression() {
            return this.rootExpression;
        }
    }
}

