/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public final class ItemMappingIterator
implements SequenceIterator,
LookaheadIterator {
    private SequenceIterator base;
    private ItemMappingFunction action;
    private Item current = null;
    private int position = 0;
    private boolean oneToOne = false;

    public ItemMappingIterator(SequenceIterator base, ItemMappingFunction action) {
        this.base = base;
        this.action = action;
    }

    public ItemMappingIterator(SequenceIterator base, ItemMappingFunction action, boolean oneToOne) {
        this.base = base;
        this.action = action;
        this.oneToOne = oneToOne;
    }

    public void setOneToOne(boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    @Override
    public Item next() throws XPathException {
        do {
            Item nextSource;
            if ((nextSource = this.base.next()) == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.current = this.action.map(nextSource);
        } while (this.current == null);
        ++this.position;
        return this.current;
    }

    @Override
    public Item current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        return new ItemMappingIterator(this.base.getAnother(), this.action, this.oneToOne);
    }

    @Override
    public int getProperties() {
        if (this.oneToOne && (this.base.getProperties() & 4) != 0) {
            return 4;
        }
        return 0;
    }
}

