/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SingletonComparison;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class GeneralComparison
extends BinaryExpression
implements ComparisonExpression {
    protected int singletonOperator;
    protected AtomicComparer comparer;

    public GeneralComparison(Expression p0, int op, Expression p1) {
        super(p0, op, p1);
        this.singletonOperator = GeneralComparison.getSingletonOperator(op);
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression e = super.simplify(visitor);
        if (e == this) {
            e = visitor.getConfiguration().getOptimizer().simplifyGeneralComparison(this, visitor.getStaticContext().isInBackwardsCompatibleMode());
        }
        ExpressionTool.copyLocationInfo(this, e);
        return e;
    }

    @Override
    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    @Override
    public int getSingletonOperator() {
        return this.singletonOperator;
    }

    @Override
    public boolean convertsUntypedToOther() {
        return true;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression oldOp0 = this.operand0;
        Expression oldOp1 = this.operand1;
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        if (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1)) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.operand0 = ExpressionTool.unsorted(opt, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(opt, this.operand1, false);
        SequenceType atomicType = SequenceType.ATOMIC_SEQUENCE;
        RoleLocator role0 = new RoleLocator(1, (Serializable)((Object)Token.tokens[this.operator]), 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, atomicType, false, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, (Serializable)((Object)Token.tokens[this.operator]), 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, atomicType, false, role1, visitor);
        if (this.operand0 != oldOp0) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != oldOp1) {
            this.adoptChildExpression(this.operand1);
        }
        ItemType t0 = this.operand0.getItemType(th);
        ItemType t1 = this.operand1.getItemType(th);
        if (t0 instanceof EmptySequenceTest || t1 instanceof EmptySequenceTest) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (((AtomicType)t0).isExternalType() || ((AtomicType)t1).isExternalType()) {
            XPathException err = new XPathException("Cannot perform comparisons involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            throw err;
        }
        BuiltInAtomicType pt0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        BuiltInAtomicType pt1 = (BuiltInAtomicType)t1.getPrimitiveItemType();
        int c0 = this.operand0.getCardinality();
        int c1 = this.operand1.getCardinality();
        if (c0 == 8192 || c1 == 8192) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (!(t0.equals(BuiltInAtomicType.ANY_ATOMIC) || t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || Type.isComparable(pt0, pt1, Token.isOrderedOperator(this.singletonOperator)))) {
            NamePool namePool = visitor.getConfiguration().getNamePool();
            XPathException err = new XPathException("Cannot compare " + t0.toString(namePool) + " to " + t1.toString(namePool));
            err.setErrorCode("XPTY0004");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        if (c0 == 16384 && c1 == 16384 && !t0.equals(BuiltInAtomicType.ANY_ATOMIC) && !t1.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            Expression e0 = this.operand0;
            Expression e1 = this.operand1;
            if (t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    e0 = new CastExpression(this.operand0, BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(e0);
                    e1 = new CastExpression(this.operand1, BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(e1);
                } else if (th.isSubType(t1, BuiltInAtomicType.NUMERIC)) {
                    e0 = new CastExpression(this.operand0, BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(e0);
                } else {
                    e0 = new CastExpression(this.operand0, (AtomicType)t1, false);
                    this.adoptChildExpression(e0);
                }
            } else if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (th.isSubType(t0, BuiltInAtomicType.NUMERIC)) {
                    e1 = new CastExpression(this.operand1, BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(e1);
                } else {
                    e1 = new CastExpression(this.operand1, (AtomicType)t0, false);
                    this.adoptChildExpression(e1);
                }
            }
            ValueComparison vc = new ValueComparison(e0, this.singletonOperator, e1);
            vc.setAtomicComparer(this.comparer);
            ExpressionTool.copyLocationInfo(this, vc);
            return visitor.typeCheck(visitor.simplify(vc), contextItemType);
        }
        StaticContext env = visitor.getStaticContext();
        if (this.comparer == null) {
            String defaultCollationName = env.getDefaultCollationName();
            StringCollator collation = env.getCollation(defaultCollationName);
            if (collation == null) {
                collation = CodepointCollator.getInstance();
            }
            this.comparer = GenericAtomicComparer.makeAtomicComparer(pt0, pt1, collation, visitor.getConfiguration().getConversionContext());
        }
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(env.makeEarlyEvaluationContext()));
        }
        return this;
    }

    private static Expression makeMinOrMax(Expression exp, String function) {
        FunctionCall fn = SystemFunction.makeSystemFunction(function, new Expression[]{exp});
        ((Minimax)fn).setIgnoreNaN(true);
        return fn;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Value value0;
        RoleLocator role;
        boolean checkTypes;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        StaticContext env = visitor.getStaticContext();
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        if (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1)) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        this.operand0 = ExpressionTool.unsorted(opt, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(opt, this.operand1, false);
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return new Literal(Value.asValue(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())));
        }
        ItemType t0 = this.operand0.getItemType(th);
        ItemType t1 = this.operand1.getItemType(th);
        int c0 = this.operand0.getCardinality();
        int c1 = this.operand1.getCardinality();
        boolean bl = checkTypes = t0 == BuiltInAtomicType.ANY_ATOMIC || t1 == BuiltInAtomicType.ANY_ATOMIC || !t0.equals(t1);
        if (!Cardinality.allowsMany(c0) && !Cardinality.allowsMany(c1)) {
            SingletonComparison sc = new SingletonComparison(this.operand0, this.singletonOperator, this.operand1, checkTypes);
            ExpressionTool.copyLocationInfo(this, sc);
            sc.setAtomicComparer(this.comparer);
            return visitor.optimize(sc, contextItemType);
        }
        if (Cardinality.expectsMany(this.operand1) && !Cardinality.expectsMany(this.operand0)) {
            GeneralComparison mc = this.getInverseComparison();
            ExpressionTool.copyLocationInfo(this, mc);
            mc.comparer = this.comparer;
            return visitor.optimize(mc, contextItemType);
        }
        if (c0 == 16384 && c1 == 16384 && !t0.equals(BuiltInAtomicType.ANY_ATOMIC) && !t1.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            Expression e0 = this.operand0;
            Expression e1 = this.operand1;
            if (t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    e0 = new CastExpression(this.operand0, BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(e0);
                    e1 = new CastExpression(this.operand1, BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(e1);
                } else if (th.isSubType(t1, BuiltInAtomicType.NUMERIC)) {
                    e0 = new CastExpression(this.operand0, BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(e0);
                } else {
                    e0 = new CastExpression(this.operand0, (AtomicType)t1, false);
                    this.adoptChildExpression(e0);
                }
            } else if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (th.isSubType(t0, BuiltInAtomicType.NUMERIC)) {
                    e1 = new CastExpression(this.operand1, BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(e1);
                } else {
                    e1 = new CastExpression(this.operand1, (AtomicType)t0, false);
                    this.adoptChildExpression(e1);
                }
            }
            ValueComparison vc = new ValueComparison(e0, this.singletonOperator, e1);
            vc.setAtomicComparer(this.comparer);
            ExpressionTool.copyLocationInfo(this, vc);
            return visitor.optimize(visitor.typeCheck(visitor.simplify(vc), contextItemType), contextItemType);
        }
        if (this.comparer == null) {
            String defaultCollationName = env.getDefaultCollationName();
            StringCollator comp = env.getCollation(defaultCollationName);
            if (comp == null) {
                comp = CodepointCollator.getInstance();
            }
            BuiltInAtomicType pt0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
            BuiltInAtomicType pt1 = (BuiltInAtomicType)t1.getPrimitiveItemType();
            this.comparer = GenericAtomicComparer.makeAtomicComparer(pt0, pt1, comp, env.getConfiguration().getConversionContext());
        }
        Expression e0 = this.operand0;
        Expression e1 = this.operand1;
        boolean numeric0 = th.isSubType(t0, BuiltInAtomicType.NUMERIC);
        boolean numeric1 = th.isSubType(t1, BuiltInAtomicType.NUMERIC);
        if (numeric1 && !numeric0) {
            role = new RoleLocator(1, (Serializable)((Object)Token.tokens[this.operator]), 0);
            e0 = TypeChecker.staticTypeCheck(e0, SequenceType.NUMERIC_SEQUENCE, false, role, visitor);
        }
        if (numeric0 && !numeric1) {
            role = new RoleLocator(1, (Serializable)((Object)Token.tokens[this.operator]), 1);
            e1 = TypeChecker.staticTypeCheck(e1, SequenceType.NUMERIC_SEQUENCE, false, role, visitor);
        }
        if (this.operand0 instanceof RangeExpression && th.isSubType(this.operand1.getItemType(th), BuiltInAtomicType.NUMERIC) && this.operator == 6 && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            Expression min = ((RangeExpression)this.operand0).operand0;
            Expression max = ((RangeExpression)this.operand0).operand1;
            IntegerRangeTest ir = new IntegerRangeTest(this.operand1, min, max);
            ExpressionTool.copyLocationInfo(this, ir);
            return ir;
        }
        if (this.operand0 instanceof Literal && (value0 = ((Literal)this.operand0).getValue()) instanceof IntegerRange && th.isSubType(this.operand1.getItemType(th), BuiltInAtomicType.NUMERIC) && this.operator == 6 && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            long min = ((IntegerRange)value0).getStart();
            long max = ((IntegerRange)value0).getEnd();
            IntegerRangeTest ir = new IntegerRangeTest(this.operand1, Literal.makeLiteral(Int64Value.makeIntegerValue(min)), Literal.makeLiteral(Int64Value.makeIntegerValue(max)));
            ExpressionTool.copyLocationInfo(this, ir);
            return ir;
        }
        if (this.operator != 6 && this.operator != 22 && (th.isSubType(t0, BuiltInAtomicType.NUMERIC) || th.isSubType(t1, BuiltInAtomicType.NUMERIC))) {
            ValueComparison vc;
            switch (this.operator) {
                case 12: 
                case 14: {
                    vc = new ValueComparison(GeneralComparison.makeMinOrMax(e0, "min"), this.singletonOperator, GeneralComparison.makeMinOrMax(e1, "max"));
                    vc.setResultWhenEmpty(BooleanValue.FALSE);
                    vc.setAtomicComparer(this.comparer);
                    break;
                }
                case 11: 
                case 13: {
                    vc = new ValueComparison(GeneralComparison.makeMinOrMax(e0, "max"), this.singletonOperator, GeneralComparison.makeMinOrMax(e1, "min"));
                    vc.setResultWhenEmpty(BooleanValue.FALSE);
                    vc.setAtomicComparer(this.comparer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operator " + this.operator);
                }
            }
            ExpressionTool.copyLocationInfo(this, vc);
            return visitor.typeCheck(vc, contextItemType);
        }
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(env.makeEarlyEvaluationContext()));
        }
        return this;
    }

    @Override
    public Expression copy() {
        GeneralComparison gc = new GeneralComparison(this.operand0.copy(), this.operator, this.operand1.copy());
        gc.comparer = this.comparer;
        gc.singletonOperator = this.singletonOperator;
        return gc;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Value seq2;
        SequenceIterator iter1;
        block11: {
            AtomicValue s1;
            int count2;
            block10: {
                iter1 = this.operand0.iterate(context);
                SequenceIterator iter2 = this.operand1.iterate(context);
                seq2 = (Value)SequenceExtent.makeSequenceExtent(iter2);
                count2 = seq2.getLength();
                if (count2 != 0) break block10;
                return false;
            }
            if (count2 != 1) break block11;
            AtomicValue s2 = (AtomicValue)seq2.itemAt(0);
            while ((s1 = (AtomicValue)iter1.next()) != null) {
                if (!GeneralComparison.compare(s1, this.singletonOperator, s2, this.comparer, true, context)) continue;
                iter1.close();
                return true;
            }
            return false;
        }
        try {
            AtomicValue s1;
            while ((s1 = (AtomicValue)iter1.next()) != null) {
                AtomicValue s2;
                SequenceIterator e2 = seq2.iterate();
                while ((s2 = (AtomicValue)e2.next()) != null) {
                    if (!GeneralComparison.compare(s1, this.singletonOperator, s2, this.comparer, true, context)) continue;
                    iter1.close();
                    e2.close();
                    return true;
                }
            }
            return false;
        }
        catch (ValidationException e) {
            XPathException err = new XPathException(e);
            err.setXPathContext(context);
            if (e.getLineNumber() == -1) {
                err.setLocator(this);
            } else {
                err.setLocator(e);
            }
            err.setErrorCodeQName(e.getErrorCodeQName());
            throw err;
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    protected static boolean compare(AtomicValue a1, int operator, AtomicValue a2, AtomicComparer comparer, boolean checkTypes, XPathContext context) throws XPathException {
        boolean u1 = a1 instanceof UntypedAtomicValue;
        boolean u2 = a2 instanceof UntypedAtomicValue;
        if (u1 != u2) {
            if (u1) {
                a1 = a2 instanceof NumericValue ? a1.convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic() : a1.convert(a2.getPrimitiveType(), true, context).asAtomic();
            } else {
                a2 = a1 instanceof NumericValue ? a2.convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic() : a2.convert(a1.getPrimitiveType(), true, context).asAtomic();
            }
            checkTypes = false;
        }
        return ValueComparison.compare(a1, operator, a2, comparer.provideContext(context), checkTypes);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    private static int getSingletonOperator(int op) {
        switch (op) {
            case 6: {
                return 50;
            }
            case 13: {
                return 54;
            }
            case 22: {
                return 51;
            }
            case 12: {
                return 53;
            }
            case 11: {
                return 52;
            }
            case 14: {
                return 55;
            }
        }
        return op;
    }

    protected GeneralComparison getInverseComparison() {
        return new GeneralComparison(this.operand1, Token.inverse(this.operator), this.operand0);
    }

    @Override
    protected void explainExtraAttributes(ExpressionPresenter out) {
        out.emitAttribute("cardinality", "many-to-many");
    }
}

