/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public abstract class Calculator
implements Serializable {
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int TIMES = 2;
    public static final int DIV = 3;
    public static final int MOD = 4;
    public static final int IDIV = 5;
    public static Calculator[] ANY_ANY = new Calculator[]{new AnyPlusAny(), new AnyMinusAny(), new AnyTimesAny(), new AnyDivAny(), new AnyModAny(), new AnyIdivAny()};
    public static Calculator[] DOUBLE_DOUBLE = new Calculator[]{new DoublePlusDouble(), new DoubleMinusDouble(), new DoubleTimesDouble(), new DoubleDivDouble(), new DoubleModDouble(), new DoubleIdivDouble()};
    public static Calculator[] DOUBLE_FLOAT = DOUBLE_DOUBLE;
    public static Calculator[] DOUBLE_DECIMAL = DOUBLE_DOUBLE;
    public static Calculator[] DOUBLE_INTEGER = DOUBLE_DOUBLE;
    public static Calculator[] FLOAT_DOUBLE = DOUBLE_DOUBLE;
    public static Calculator[] FLOAT_FLOAT = new Calculator[]{new FloatPlusFloat(), new FloatMinusFloat(), new FloatTimesFloat(), new FloatDivFloat(), new FloatModFloat(), new FloatIdivFloat()};
    public static Calculator[] FLOAT_DECIMAL = FLOAT_FLOAT;
    public static Calculator[] FLOAT_INTEGER = FLOAT_FLOAT;
    public static Calculator[] DECIMAL_DOUBLE = DOUBLE_DOUBLE;
    public static Calculator[] DECIMAL_FLOAT = FLOAT_FLOAT;
    public static Calculator[] DECIMAL_DECIMAL = new Calculator[]{new DecimalPlusDecimal(), new DecimalMinusDecimal(), new DecimalTimesDecimal(), new DecimalDivDecimal(), new DecimalModDecimal(), new DecimalIdivDecimal()};
    public static Calculator[] DECIMAL_INTEGER = DECIMAL_DECIMAL;
    public static Calculator[] INTEGER_DOUBLE = DOUBLE_DOUBLE;
    public static Calculator[] INTEGER_FLOAT = FLOAT_FLOAT;
    public static Calculator[] INTEGER_DECIMAL = DECIMAL_DECIMAL;
    public static Calculator[] INTEGER_INTEGER = new Calculator[]{new IntegerPlusInteger(), new IntegerMinusInteger(), new IntegerTimesInteger(), new IntegerDivInteger(), new IntegerModInteger(), new IntegerIdivInteger()};
    public static Calculator[] DATETIME_DATETIME;
    public static Calculator[] DATETIME_DURATION;
    public static Calculator[] DURATION_DATETIME;
    public static Calculator[] DURATION_DURATION;
    public static Calculator[] DURATION_NUMERIC;
    public static Calculator[] NUMERIC_DURATION;
    private static IntHashMap<Calculator[]> table;
    private static IntHashMap<String> nameTable;

    static {
        Calculator[] calculatorArray = new Calculator[6];
        calculatorArray[1] = new DateTimeMinusDateTime();
        DATETIME_DATETIME = calculatorArray;
        Calculator[] calculatorArray2 = new Calculator[6];
        calculatorArray2[0] = new DateTimePlusDuration();
        calculatorArray2[1] = new DateTimeMinusDuration();
        DATETIME_DURATION = calculatorArray2;
        Calculator[] calculatorArray3 = new Calculator[6];
        calculatorArray3[0] = new DurationPlusDateTime();
        DURATION_DATETIME = calculatorArray3;
        Calculator[] calculatorArray4 = new Calculator[6];
        calculatorArray4[0] = new DurationPlusDuration();
        calculatorArray4[1] = new DurationMinusDuration();
        calculatorArray4[3] = new DurationDivDuration();
        DURATION_DURATION = calculatorArray4;
        Calculator[] calculatorArray5 = new Calculator[6];
        calculatorArray5[2] = new DurationTimesNumeric();
        calculatorArray5[3] = new DurationDivNumeric();
        DURATION_NUMERIC = calculatorArray5;
        Calculator[] calculatorArray6 = new Calculator[6];
        calculatorArray6[2] = new NumericTimesDuration();
        NUMERIC_DURATION = calculatorArray6;
        table = new IntHashMap(100);
        nameTable = new IntHashMap(100);
        Calculator.def(517, 517, DOUBLE_DOUBLE, "DOUBLE_DOUBLE");
        Calculator.def(517, 516, DOUBLE_FLOAT, "DOUBLE_FLOAT");
        Calculator.def(517, 515, DOUBLE_DECIMAL, "DOUBLE_DECIMAL");
        Calculator.def(517, 532, DOUBLE_INTEGER, "DOUBLE_INTEGER");
        Calculator.def(516, 517, FLOAT_DOUBLE, "FLOAT_DOUBLE");
        Calculator.def(516, 516, FLOAT_FLOAT, "FLOAT_FLOAT");
        Calculator.def(516, 515, FLOAT_DECIMAL, "FLOAT_DECIMAL");
        Calculator.def(516, 532, FLOAT_INTEGER, "FLOAT_INTEGER");
        Calculator.def(515, 517, DECIMAL_DOUBLE, "DECIMAL_DOUBLE");
        Calculator.def(515, 516, DECIMAL_FLOAT, "DECIMAL_FLOAT");
        Calculator.def(515, 515, DECIMAL_DECIMAL, "DECIMAL_DECIMAL");
        Calculator.def(515, 532, DECIMAL_INTEGER, "DECIMAL_INTEGER");
        Calculator.def(532, 517, INTEGER_DOUBLE, "INTEGER_DOUBLE");
        Calculator.def(532, 516, INTEGER_FLOAT, "INTEGER_FLOAT");
        Calculator.def(532, 515, INTEGER_DECIMAL, "INTEGER_DECIMAL");
        Calculator.def(532, 532, INTEGER_INTEGER, "INTEGER_INTEGER");
        Calculator.def(519, 519, DATETIME_DATETIME, "DATETIME_DATETIME");
        Calculator.def(519, 518, DATETIME_DURATION, "DATETIME_DURATION");
        Calculator.def(518, 519, DURATION_DATETIME, "DURATION_DATETIME");
        Calculator.def(518, 518, DURATION_DURATION, "DURATION_DURATION");
        Calculator.def(518, 517, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(518, 516, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(518, 515, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(518, 532, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(517, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.def(516, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.def(515, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.def(532, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
    }

    private static void def(int typeA, int typeB, Calculator[] calculatorSet, String setName) {
        int key = (typeA & 0xFFFF) << 16 | typeB & 0xFFFF;
        table.put(key, calculatorSet);
        nameTable.put(key, setName);
        if (typeA == 518) {
            Calculator.def(634, typeB, calculatorSet, setName);
            Calculator.def(633, typeB, calculatorSet, setName);
        }
        if (typeB == 518) {
            Calculator.def(typeA, 634, calculatorSet, setName);
            Calculator.def(typeA, 633, calculatorSet, setName);
        }
        if (typeA == 519) {
            Calculator.def(521, typeB, calculatorSet, setName);
            Calculator.def(520, typeB, calculatorSet, setName);
        }
        if (typeB == 519) {
            Calculator.def(typeA, 521, calculatorSet, setName);
            Calculator.def(typeA, 520, calculatorSet, setName);
        }
        if (typeA == 517) {
            Calculator.def(631, typeB, calculatorSet, setName);
        }
        if (typeB == 517) {
            Calculator.def(typeA, 631, calculatorSet, setName);
        }
    }

    public static Calculator getCalculator(int typeA, int typeB, int operator, boolean mustResolve) {
        int key = (typeA & 0xFFFF) << 16 | typeB & 0xFFFF;
        Calculator[] set = table.get(key);
        if (set == null) {
            if (mustResolve) {
                return null;
            }
            return ANY_ANY[operator];
        }
        return set[operator];
    }

    public static String getCalculatorSetName(int typeA, int typeB) {
        int key = (typeA & 0xFFFF) << 16 | typeB & 0xFFFF;
        return nameTable.get(key);
    }

    public abstract AtomicValue compute(AtomicValue var1, AtomicValue var2, XPathContext var3) throws XPathException;

    public abstract AtomicType getResultType(AtomicType var1, AtomicType var2);

    private static class AnyDivAny
    extends Calculator {
        private AnyDivAny() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyDivAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 3, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for div operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyIdivAny
    extends Calculator {
        private AnyIdivAny() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyIdivAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 5, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for idiv operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyMinusAny
    extends Calculator {
        private AnyMinusAny() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyMinusAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 1, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for - operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyModAny
    extends Calculator {
        private AnyModAny() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyModAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 4, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for mod operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyPlusAny
    extends Calculator {
        private AnyPlusAny() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyPlusAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 0, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for + operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyTimesAny
    extends Calculator {
        private AnyTimesAny() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyTimesAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 2, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for * operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class DateTimeMinusDateTime
    extends Calculator {
        private DateTimeMinusDateTime() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((CalendarValue)a).subtract((CalendarValue)b, c);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DAY_TIME_DURATION;
        }
    }

    private static class DateTimeMinusDuration
    extends Calculator {
        private DateTimeMinusDuration() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((CalendarValue)a).add(((DurationValue)b).multiply(-1.0));
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class DateTimePlusDuration
    extends Calculator {
        private DateTimePlusDuration() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((CalendarValue)a).add((DurationValue)b);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class DecimalDivDecimal
    extends Calculator {
        private DecimalDivDecimal() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            BigDecimal A = ((NumericValue)a).getDecimalValue();
            BigDecimal B = ((NumericValue)b).getDecimalValue();
            int scale = Math.max(18, Math.max(A.scale(), B.scale()));
            try {
                BigDecimal result = A.divide(B, scale, 5);
                return new DecimalValue(result);
            }
            catch (ArithmeticException err) {
                if (((NumericValue)b).compareTo(0L) == 0) {
                    throw new XPathException("Decimal divide by zero", "FOAR0001", c);
                }
                throw err;
            }
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalIdivDecimal
    extends Calculator {
        private DecimalIdivDecimal() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).idiv((IntegerValue)b);
            }
            BigDecimal A = ((NumericValue)a).getDecimalValue();
            BigDecimal B = ((NumericValue)b).getDecimalValue();
            if (B.signum() == 0) {
                throw new XPathException("Integer division by zero", "FOAR0001", c);
            }
            BigInteger quot = A.divide(B, 0, 1).toBigInteger();
            return BigIntegerValue.makeIntegerValue(quot);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class DecimalMinusDecimal
    extends Calculator {
        private DecimalMinusDecimal() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).minus((IntegerValue)b);
            }
            return new DecimalValue(((NumericValue)a).getDecimalValue().subtract(((NumericValue)b).getDecimalValue()));
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalModDecimal
    extends Calculator {
        private DecimalModDecimal() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).mod((IntegerValue)b);
            }
            BigDecimal A = ((NumericValue)a).getDecimalValue();
            BigDecimal B = ((NumericValue)b).getDecimalValue();
            try {
                BigDecimal quotient = A.divide(B, 0, 1);
                BigDecimal remainder = A.subtract(quotient.multiply(B));
                return new DecimalValue(remainder);
            }
            catch (ArithmeticException err) {
                if (((NumericValue)b).compareTo(0L) == 0) {
                    throw new XPathException("Decimal modulo zero", "FOAR0001", c);
                }
                throw err;
            }
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalPlusDecimal
    extends Calculator {
        private DecimalPlusDecimal() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).plus((IntegerValue)b);
            }
            return new DecimalValue(((NumericValue)a).getDecimalValue().add(((NumericValue)b).getDecimalValue()));
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalTimesDecimal
    extends Calculator {
        private DecimalTimesDecimal() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).times((IntegerValue)b);
            }
            return new DecimalValue(((NumericValue)a).getDecimalValue().multiply(((NumericValue)b).getDecimalValue()));
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DoubleDivDouble
    extends Calculator {
        private DoubleDivDouble() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new DoubleValue(((NumericValue)a).getDoubleValue() / ((NumericValue)b).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoubleIdivDouble
    extends Calculator {
        private DoubleIdivDouble() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            double A = ((NumericValue)a).getDoubleValue();
            double B = ((NumericValue)b).getDoubleValue();
            if (B == 0.0) {
                throw new XPathException("Integer division by zero", "FOAR0001", c);
            }
            if (Double.isNaN(A) || Double.isInfinite(A)) {
                throw new XPathException("First operand of idiv is NaN or infinity", "FOAR0002", c);
            }
            if (Double.isNaN(B)) {
                throw new XPathException("Second operand of idiv is NaN", "FOAR0002", c);
            }
            return new DoubleValue(A / B).convert(BuiltInAtomicType.INTEGER, true, c).asAtomic();
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class DoubleMinusDouble
    extends Calculator {
        private DoubleMinusDouble() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new DoubleValue(((NumericValue)a).getDoubleValue() - ((NumericValue)b).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoubleModDouble
    extends Calculator {
        private DoubleModDouble() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new DoubleValue(((NumericValue)a).getDoubleValue() % ((NumericValue)b).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoublePlusDouble
    extends Calculator {
        private DoublePlusDouble() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new DoubleValue(((NumericValue)a).getDoubleValue() + ((NumericValue)b).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoubleTimesDouble
    extends Calculator {
        private DoubleTimesDouble() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new DoubleValue(((NumericValue)a).getDoubleValue() * ((NumericValue)b).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DurationDivDuration
    extends Calculator {
        private DurationDivDuration() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((DurationValue)a).divide((DurationValue)b);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DurationDivNumeric
    extends Calculator {
        private DurationDivNumeric() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            double d = 1.0 / ((NumericValue)b).getDoubleValue();
            return ((DurationValue)a).multiply(d);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class DurationMinusDuration
    extends Calculator {
        private DurationMinusDuration() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((DurationValue)a).subtract((DurationValue)b);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class DurationPlusDateTime
    extends Calculator {
        private DurationPlusDateTime() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((CalendarValue)b).add((DurationValue)a);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeB;
        }
    }

    private static class DurationPlusDuration
    extends Calculator {
        private DurationPlusDuration() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((DurationValue)a).add((DurationValue)b);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class DurationTimesNumeric
    extends Calculator {
        private DurationTimesNumeric() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((DurationValue)a).multiply(((NumericValue)b).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class FloatDivFloat
    extends Calculator {
        private FloatDivFloat() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new FloatValue(((NumericValue)a).getFloatValue() / ((NumericValue)b).getFloatValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatIdivFloat
    extends Calculator {
        private FloatIdivFloat() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            float A = ((NumericValue)a).getFloatValue();
            float B = ((NumericValue)b).getFloatValue();
            if ((double)B == 0.0) {
                throw new XPathException("Integer division by zero", "FOAR0001", c);
            }
            if (Double.isNaN(A) || Double.isInfinite(A)) {
                throw new XPathException("First operand of idiv is NaN or infinity", "FOAR0002", c);
            }
            if (Double.isNaN(B)) {
                throw new XPathException("Second operand of idiv is NaN", "FOAR0002", c);
            }
            return new FloatValue(A / B).convert(BuiltInAtomicType.INTEGER, true, c).asAtomic();
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class FloatMinusFloat
    extends Calculator {
        private FloatMinusFloat() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new FloatValue(((NumericValue)a).getFloatValue() - ((NumericValue)b).getFloatValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatModFloat
    extends Calculator {
        private FloatModFloat() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new FloatValue(((NumericValue)a).getFloatValue() % ((NumericValue)b).getFloatValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatPlusFloat
    extends Calculator {
        private FloatPlusFloat() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new FloatValue(((NumericValue)a).getFloatValue() + ((NumericValue)b).getFloatValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatTimesFloat
    extends Calculator {
        private FloatTimesFloat() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new FloatValue(((NumericValue)a).getFloatValue() * ((NumericValue)b).getFloatValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class IntegerDivInteger
    extends Calculator {
        private IntegerDivInteger() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).div((IntegerValue)b);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class IntegerIdivInteger
    extends Calculator {
        private IntegerIdivInteger() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).idiv((IntegerValue)b);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerMinusInteger
    extends Calculator {
        private IntegerMinusInteger() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).minus((IntegerValue)b);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerModInteger
    extends Calculator {
        private IntegerModInteger() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).mod((IntegerValue)b);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerPlusInteger
    extends Calculator {
        private IntegerPlusInteger() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).plus((IntegerValue)b);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerTimesInteger
    extends Calculator {
        private IntegerTimesInteger() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).times((IntegerValue)b);
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class NumericTimesDuration
    extends Calculator {
        private NumericTimesDuration() {
        }

        @Override
        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((DurationValue)b).multiply(((NumericValue)a).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeB;
        }
    }
}

