/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntSet;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class XMLIndenter
extends ProxyReceiver {
    private int level = 0;
    private int indentSpaces = 3;
    private char[] indentChars = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private boolean sameline = false;
    private boolean afterStartTag = false;
    private boolean afterEndTag = true;
    private boolean allWhite = true;
    private int line = 0;
    private int column = 0;
    private int suppressedAtLevel = -1;
    private int xmlspace;
    private IntSet suppressedElements = null;
    private IntSet doubleSpacedElements = null;

    public void setOutputProperties(Properties props) {
        int fp;
        String clarkName;
        StringTokenizer st;
        NamePool pool;
        String s = props.getProperty("{http://saxon.sf.net/}indent-spaces");
        if (s == null) {
            this.indentSpaces = 3;
        } else {
            try {
                this.indentSpaces = Integer.parseInt(Whitespace.trim(s));
            }
            catch (NumberFormatException numberFormatException) {
                this.indentSpaces = 3;
            }
        }
        String omit = props.getProperty("omit-xml-declaration");
        this.afterEndTag = omit == null || !Whitespace.trim(omit).equals("yes") || props.getProperty("doctype-system") != null;
        s = props.getProperty("{http://saxon.sf.net/}suppress-indentation");
        if (s != null) {
            this.suppressedElements = new IntHashSet(8);
            pool = this.getNamePool();
            st = new StringTokenizer(s, " \t\r\n");
            while (st.hasMoreTokens()) {
                clarkName = st.nextToken();
                fp = pool.allocateClarkName(clarkName);
                this.suppressedElements.add(fp);
            }
        }
        if ((s = props.getProperty("{http://saxon.sf.net/}double-space")) != null) {
            this.doubleSpacedElements = new IntHashSet(8);
            pool = this.getNamePool();
            st = new StringTokenizer(s, " \t\r\n");
            while (st.hasMoreTokens()) {
                clarkName = st.nextToken();
                fp = pool.allocateClarkName(clarkName);
                this.doubleSpacedElements.add(fp);
            }
        }
    }

    @Override
    public void open() throws XPathException {
        this.nextReceiver.open();
        this.xmlspace = 386;
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        SchemaType type;
        if (this.afterStartTag || this.afterEndTag) {
            if (this.doubleSpacedElements != null && this.doubleSpacedElements.contains(nameCode & 0xFFFFF)) {
                this.nextReceiver.characters("\n", 0, 0);
                this.line = 0;
                this.column = 0;
            }
            this.indent();
        }
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        ++this.level;
        this.sameline = true;
        this.afterStartTag = true;
        this.afterEndTag = false;
        this.allWhite = true;
        this.line = 0;
        if (this.suppressedElements != null && this.suppressedElements.contains(nameCode & 0xFFFFF)) {
            this.suppressedAtLevel = this.level;
        }
        if (typeCode >= 1024 && this.suppressedAtLevel < 0 && (type = this.getConfiguration().getSchemaType(typeCode)) != null && type.isComplexType() && ((ComplexType)type).isMixedContent()) {
            this.suppressedAtLevel = this.level;
        }
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if ((nameCode & 0xFFFFF) == this.xmlspace && value.equals("preserve") && this.suppressedAtLevel < 0) {
            this.suppressedAtLevel = this.level;
        }
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        --this.level;
        if (this.afterEndTag && !this.sameline) {
            this.indent();
        }
        this.nextReceiver.endElement();
        this.sameline = false;
        this.afterEndTag = true;
        this.afterStartTag = false;
        this.allWhite = true;
        this.line = 0;
        if (this.level == this.suppressedAtLevel - 1) {
            this.suppressedAtLevel = -1;
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.afterEndTag) {
            this.indent();
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
        this.afterStartTag = false;
        this.afterEndTag = false;
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        int i = 0;
        while (i < chars.length()) {
            char c = chars.charAt(i);
            if (c == '\n') {
                this.sameline = false;
                ++this.line;
                this.column = 0;
            }
            if (!Character.isWhitespace(c)) {
                this.allWhite = false;
            }
            ++this.column;
            ++i;
        }
        this.nextReceiver.characters(chars, locationId, properties);
        if (!this.allWhite) {
            this.afterStartTag = false;
            this.afterEndTag = false;
        }
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.afterEndTag) {
            this.indent();
        }
        this.nextReceiver.comment(chars, locationId, properties);
        this.afterStartTag = false;
        this.afterEndTag = false;
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    private void indent() throws XPathException {
        if (this.suppressedAtLevel >= 0) {
            return;
        }
        int spaces = this.level * this.indentSpaces;
        if (this.line > 0 && (spaces -= this.column) <= 0) {
            return;
        }
        if (spaces + 2 >= this.indentChars.length) {
            int increment = 5 * this.indentSpaces;
            if (spaces + 2 > this.indentChars.length + increment) {
                increment += spaces + 2;
            }
            char[] c2 = new char[this.indentChars.length + increment];
            System.arraycopy(this.indentChars, 0, c2, 0, this.indentChars.length);
            Arrays.fill(c2, this.indentChars.length, c2.length, ' ');
            this.indentChars = c2;
        }
        int start = this.line == 0 ? 0 : 1;
        this.nextReceiver.characters(new CharSlice(this.indentChars, start, spaces + 1), 0, 4);
        this.sameline = false;
    }
}

