/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.IntArraySet;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;

public class StartTagBuffer
extends ProxyReceiver
implements NamespaceResolver {
    LocationProvider inputLocationProvider;
    int elementNameCode;
    int elementTypeCode;
    int elementLocationId;
    int elementProperties;
    AttributeCollectionImpl bufferedAttributes;
    private boolean acceptAttributes;
    private boolean inDocument;
    private int[] namespaces = new int[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;
    private int attCount = 0;
    private NodeInfo elementNode;

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.bufferedAttributes = new AttributeCollectionImpl(pipe.getConfiguration());
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.depth == 0) {
            ++this.depth;
            super.startDocument(properties);
        }
        this.acceptAttributes = false;
        this.inDocument = true;
    }

    @Override
    public void endDocument() throws XPathException {
        if (this.depth == 1) {
            --this.depth;
            super.endDocument();
        }
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.elementNameCode = nameCode;
        this.elementTypeCode = typeCode;
        this.elementLocationId = locationId;
        this.elementProperties = properties;
        this.bufferedAttributes.clear();
        this.countStack[this.depth] = 0;
        if (++this.depth >= this.countStack.length) {
            int[] newstack = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, newstack, 0, this.depth);
            this.countStack = newstack;
        }
        this.acceptAttributes = true;
        this.inDocument = false;
        if ((properties & 0x40) == 0) {
            this.namespace(this.getNamePool().getNamespaceCode(nameCode), 0);
        }
        this.attCount = 0;
        this.elementNode = null;
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        if (!this.acceptAttributes) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(13, this.getNamePool().getPrefixFromNamespaceCode(namespaceCode), this.getPipelineConfiguration().getHostLanguage(), this.inDocument, false);
        }
        int n = 0;
        while (n < this.countStack[this.depth - 1]) {
            if (this.namespaces[this.namespacesSize - 1 - n] == namespaceCode) {
                return;
            }
            ++n;
        }
        this.addToStack(namespaceCode);
        int n2 = this.depth - 1;
        this.countStack[n2] = this.countStack[n2] + 1;
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (!this.acceptAttributes) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(2, this.getNamePool().getDisplayName(nameCode), this.getPipelineConfiguration().getHostLanguage(), this.inDocument, false);
        }
        if ((properties & 0x40) == 0 && NamePool.isPrefixed(nameCode)) {
            nameCode = this.checkProposedPrefix(nameCode, this.attCount++);
        }
        this.bufferedAttributes.addAttribute(nameCode, typeCode, value.toString(), locationId, properties);
    }

    private void addToStack(int nscode) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] newlist = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, newlist, 0, this.namespacesSize);
            this.namespaces = newlist;
        }
        this.namespaces[this.namespacesSize++] = nscode;
    }

    @Override
    public void startContent() throws XPathException {
        this.nextReceiver.startElement(this.elementNameCode, this.elementTypeCode, this.elementLocationId, this.elementProperties | 0x40);
        this.declareNamespacesForStartElement();
        int length = this.bufferedAttributes.getLength();
        int i = 0;
        while (i < length) {
            this.nextReceiver.attribute(this.bufferedAttributes.getNameCode(i), this.bufferedAttributes.getTypeAnnotation(i), this.bufferedAttributes.getValue(i), this.bufferedAttributes.getLocationId(i), this.bufferedAttributes.getProperties(i) | 0x40);
            ++i;
        }
        this.acceptAttributes = false;
        this.nextReceiver.startContent();
    }

    protected void declareNamespacesForStartElement() throws XPathException {
        int i = this.namespacesSize - this.countStack[this.depth - 1];
        while (i < this.namespacesSize) {
            this.nextReceiver.namespace(this.namespaces[i], 0);
            ++i;
        }
    }

    public int[] getLocalNamespaces() {
        int size = this.countStack[this.depth - 1];
        if (size == 0) {
            return IntArraySet.EMPTY_INT_ARRAY;
        }
        int[] nscodes = new int[this.countStack[this.depth - 1]];
        System.arraycopy(this.namespaces, this.namespacesSize - size, nscodes, 0, size);
        return nscodes;
    }

    protected void declareAllNamespaces() throws XPathException {
        int i = 0;
        while (i < this.namespacesSize) {
            this.nextReceiver.namespace(this.namespaces[i], 0);
            ++i;
        }
    }

    @Override
    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
        this.undeclareNamespacesForElement();
    }

    protected void undeclareNamespacesForElement() {
        this.namespacesSize -= this.countStack[--this.depth];
    }

    public int getElementNameCode() {
        return this.elementNameCode;
    }

    public boolean hasAttributes() {
        return this.bufferedAttributes.getLength() > 0;
    }

    public String getAttribute(int nameCode) {
        return this.bufferedAttributes.getValueByFingerprint(nameCode & 0xFFFFF);
    }

    public AttributeCollection getAllAttributes() {
        return this.bufferedAttributes;
    }

    protected short getURICode(short prefixCode) {
        int i = this.namespacesSize - 1;
        while (i >= 0) {
            if (this.namespaces[i] >> 16 == prefixCode) {
                short uriCode = (short)(this.namespaces[i] & 0xFFFF);
                if (uriCode == 0) break;
                return uriCode;
            }
            --i;
        }
        if (prefixCode == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        NamePool pool = this.getNamePool();
        if (!(prefix != null && prefix.length() != 0 || useDefault)) {
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short prefixCode = pool.getCodeForPrefix(prefix);
        short uriCode = this.getURICode(prefixCode);
        if (uriCode == -1) {
            return null;
        }
        return pool.getURIFromURICode(uriCode);
    }

    public Iterator iteratePrefixes() {
        NamePool pool = this.getNamePool();
        ArrayList<String> prefixes = new ArrayList<String>(this.namespacesSize);
        int i = this.namespacesSize - 1;
        while (i >= 0) {
            String prefix = pool.getPrefixFromNamespaceCode(this.namespaces[i]);
            if (!prefixes.contains(prefix)) {
                prefixes.add(prefix);
            }
            --i;
        }
        prefixes.add("xml");
        return prefixes.iterator();
    }

    private int checkProposedPrefix(int nameCode, int seq) throws XPathException {
        NamePool namePool = this.getNamePool();
        int nscode = namePool.getNamespaceCode(nameCode);
        int nsprefix = nscode >> 16;
        short existingURICode = this.getURICode((short)nsprefix);
        if (existingURICode == -1) {
            this.namespace(nscode, 0);
            return nameCode;
        }
        if ((nscode & 0xFFFF) == existingURICode) {
            return nameCode;
        }
        String prefix = this.getSubstitutePrefix(nscode, seq);
        int newCode = namePool.allocate(prefix, namePool.getURI(nameCode), namePool.getLocalName(nameCode));
        this.namespace(namePool.getNamespaceCode(newCode), 0);
        return newCode;
    }

    private String getSubstitutePrefix(int nscode, int seq) {
        String prefix = this.getNamePool().getPrefixFromNamespaceCode(nscode);
        return String.valueOf(prefix) + '_' + seq;
    }

    public NodeInfo getElementNode() throws XPathException {
        if (this.elementNode == null) {
            int len = this.bufferedAttributes.getLength();
            TinyBuilder builder = new TinyBuilder();
            builder.setSizeParameters(new int[]{2, len + 2, this.namespacesSize + 2, 16});
            builder.setPipelineConfiguration(this.getPipelineConfiguration());
            builder.open();
            builder.startElement(this.elementNameCode, 631, 0, 0);
            int i = 0;
            while (i < this.namespacesSize) {
                builder.namespace(this.namespaces[i], 0);
                ++i;
            }
            i = 0;
            while (i < len) {
                builder.attribute(this.bufferedAttributes.getNameCode(i), 631, this.bufferedAttributes.getValue(i), 0, 0);
                ++i;
            }
            builder.startContent();
            builder.endElement();
            this.elementNode = builder.getCurrentRoot();
        }
        return this.elementNode;
    }
}

