/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMWriter
implements Receiver {
    private PipelineConfiguration pipe;
    private NamePool namePool;
    private Node currentNode;
    private Document document;
    private Node nextSibling;
    private int level = 0;
    private boolean canNormalize = true;
    private String systemId;

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.namePool = pipe.getConfiguration().getNamePool();
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
    }

    @Override
    public void endDocument() throws XPathException {
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        String qname = this.namePool.getDisplayName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        try {
            Element element = this.document.createElementNS("".equals(uri) ? null : uri, qname);
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(element, this.nextSibling);
            } else {
                this.currentNode.appendChild(element);
            }
            this.currentNode = element;
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
        ++this.level;
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        try {
            String prefix = this.namePool.getPrefixFromNamespaceCode(namespaceCode);
            String uri = this.namePool.getURIFromNamespaceCode(namespaceCode);
            Element element = (Element)this.currentNode;
            if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                if (prefix.length() == 0) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", uri);
                } else {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
                }
            }
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        String qname = this.namePool.getDisplayName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        try {
            Element element = (Element)this.currentNode;
            element.setAttributeNS("".equals(uri) ? null : uri, qname, value.toString());
            if ((nameCode & 0xFFFFF) == 388 || (properties & 0x800) != 0) {
                String localName = this.namePool.getLocalName(nameCode);
                element.setIdAttributeNS(uri, localName, true);
            }
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public void startContent() throws XPathException {
    }

    @Override
    public void endElement() throws XPathException {
        if (this.canNormalize) {
            try {
                this.currentNode.normalize();
            }
            catch (Throwable throwable) {
                this.canNormalize = false;
            }
        }
        this.currentNode = this.currentNode.getParentNode();
        --this.level;
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        try {
            Text text = this.document.createTextNode(chars.toString());
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(text, this.nextSibling);
            } else if (this.currentNode.getNodeType() == 9) {
                if (!Whitespace.isWhite(chars)) {
                    throw new XPathException("The DOM model does not allow text as a direct child of a document node");
                }
            } else {
                this.currentNode.appendChild(text);
            }
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        try {
            ProcessingInstruction pi = this.document.createProcessingInstruction(target, data.toString());
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(pi, this.nextSibling);
            } else {
                this.currentNode.appendChild(pi);
            }
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        try {
            Comment comment = this.document.createComment(chars.toString());
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(comment, this.nextSibling);
            } else {
                this.currentNode.appendChild(comment);
            }
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public void setNode(Node node) {
        if (node == null) {
            return;
        }
        this.currentNode = node;
        this.document = node.getNodeType() == 9 ? (Document)node : this.currentNode.getOwnerDocument();
    }

    public void setNextSibling(Node nextSibling) {
        this.nextSibling = nextSibling;
    }
}

