/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TemplatesHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetStripper;
import net.sf.saxon.style.UseWhenFilter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import org.xml.sax.Locator;

public class TemplatesHandlerImpl
extends ReceivingContentHandler
implements TemplatesHandler {
    private TreeBuilder builder;
    private StyleNodeFactory nodeFactory;
    private Templates templates;
    private String systemId;

    protected TemplatesHandlerImpl(Configuration config) {
        this.setPipelineConfiguration(config.makePipelineConfiguration());
        this.nodeFactory = config.getStyleNodeFactory();
        this.builder = new TreeBuilder();
        this.builder.setPipelineConfiguration(this.getPipelineConfiguration());
        this.builder.setNodeFactory(this.nodeFactory);
        this.builder.setLineNumbering(true);
        StartTagBuffer startTagBuffer = new StartTagBuffer();
        UseWhenFilter useWhenFilter = new UseWhenFilter(startTagBuffer);
        useWhenFilter.setUnderlyingReceiver(this.builder);
        useWhenFilter.setPipelineConfiguration(this.getPipelineConfiguration());
        startTagBuffer.setUnderlyingReceiver(useWhenFilter);
        startTagBuffer.setPipelineConfiguration(this.getPipelineConfiguration());
        StylesheetStripper styleStripper = new StylesheetStripper();
        styleStripper.setUnderlyingReceiver(startTagBuffer);
        styleStripper.setPipelineConfiguration(this.getPipelineConfiguration());
        CommentStripper commentStripper = new CommentStripper();
        commentStripper.setUnderlyingReceiver(styleStripper);
        commentStripper.setPipelineConfiguration(this.getPipelineConfiguration());
        this.setReceiver(commentStripper);
    }

    @Override
    public Templates getTemplates() {
        if (this.templates == null) {
            DocumentImpl doc = (DocumentImpl)this.builder.getCurrentRoot();
            this.builder.reset();
            if (doc == null) {
                return null;
            }
            Configuration config = this.getConfiguration();
            CompilerInfo info = new CompilerInfo(config.getDefaultXsltCompilerInfo());
            PreparedStylesheet sheet = new PreparedStylesheet(config, info);
            try {
                sheet.setStylesheetDocument(doc, this.nodeFactory);
                this.templates = sheet;
            }
            catch (XPathException tce) {
                if (!tce.hasBeenReported()) {
                    try {
                        info.getErrorListener().fatalError(tce);
                    }
                    catch (TransformerException transformerException) {}
                }
                throw new IllegalStateException(tce.getMessage());
            }
        }
        return this.templates;
    }

    @Override
    public void setSystemId(String url) {
        this.systemId = url;
        this.builder.setSystemId(url);
        super.setDocumentLocator(new Locator(){

            @Override
            public int getColumnNumber() {
                return -1;
            }

            @Override
            public int getLineNumber() {
                return -1;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return TemplatesHandlerImpl.this.systemId;
            }
        });
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.systemId == null) {
            super.setDocumentLocator(locator);
        }
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }
}

