/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

public class ASN1Object {
    private byte[] content;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ASN1Object(byte[] content) {
        this.content = content;
    }

    public String toString() {
        if (this.content == null) {
            return new String();
        }
        return new String(ASN1Object.encodeHex(this.content));
    }

    private static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < l) {
            out[j++] = DIGITS_LOWER[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & data[i]];
            ++i;
        }
        return out;
    }
}

