/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;

final class SecuritySupport {
    private SecuritySupport() {
    }

    static ClassLoader getContextClassLoader() {
        return SecuritySupport.class.getClassLoader();
    }

    static String getSystemProperty(final String propName) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propName);
            }
        });
    }

    static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    static InputStream getURLInputStream(final URL url) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return url.openStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    static URL getResourceAsURL(final ClassLoader cl, final String name) {
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL url = cl == null ? ClassLoader.getSystemResource(name) : cl.getResource(name);
                return url;
            }
        });
    }

    static Enumeration getResources(final ClassLoader cl, final String name) throws IOException {
        try {
            return (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Enumeration<URL> enumeration = cl == null ? ClassLoader.getSystemResources(name) : cl.getResources(name);
                    return enumeration;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    static InputStream getResourceAsStream(final ClassLoader cl, final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InputStream ris = cl == null ? ClassLoader.getSystemResourceAsStream(name) : cl.getResourceAsStream(name);
                return ris;
            }
        });
    }

    static boolean doesFileExist(final File f) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return f.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }
}

