/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.invocation.Invocation;
import org.mockito.verification.VerificationMode;

public class AtMost
implements VerificationMode {
    private final int maxNumberOfInvocations;
    private final InvocationMarker invocationMarker = new InvocationMarker();

    public AtMost(int maxNumberOfInvocations) {
        if (maxNumberOfInvocations < 0) {
            throw new MockitoException("Negative value is not allowed here");
        }
        this.maxNumberOfInvocations = maxNumberOfInvocations;
    }

    @Override
    public void verify(VerificationData data) {
        InvocationMatcher wanted;
        InvocationsFinder finder = new InvocationsFinder();
        List<Invocation> invocations = data.getAllInvocations();
        List<Invocation> found = finder.findInvocations(invocations, wanted = data.getWanted());
        int foundSize = found.size();
        if (foundSize > this.maxNumberOfInvocations) {
            new Reporter().wantedAtMostX(this.maxNumberOfInvocations, foundSize);
        }
        this.invocationMarker.markVerified(found, (CapturesArgumensFromInvocation)wanted);
    }
}

