/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import org.mockito.internal.util.reflection.AccessibilityChanger;

public class FieldSetter {
    private final Object target;
    private final Field field;

    public FieldSetter(Object target, Field field) {
        this.target = target;
        this.field = field;
    }

    public void set(Object value) {
        AccessibilityChanger changer = new AccessibilityChanger();
        changer.enableAccess(this.field);
        try {
            this.field.set(this.target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access not authorized on field '" + this.field + "' of object '" + this.target + "' with value: '" + value + "'", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Wrong argument on field '" + this.field + "' of object '" + this.target + "' with value: '" + value + "', \n" + "reason : " + e.getMessage(), e);
        }
        changer.safelyDisableAccess(this.field);
    }
}

