/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.matchers.MatcherDecorator;
import org.mockito.internal.matchers.VarargMatcher;
import org.mockito.invocation.Invocation;

public class ArgumentsComparator {
    public boolean argumentsMatch(InvocationMatcher invocationMatcher, Invocation actual) {
        Object[] actualArgs = actual.getArguments();
        return this.argumentsMatch(invocationMatcher, actualArgs) || this.varArgsMatch(invocationMatcher, actual);
    }

    public boolean argumentsMatch(InvocationMatcher invocationMatcher, Object[] actualArgs) {
        if (actualArgs.length != invocationMatcher.getMatchers().size()) {
            return false;
        }
        int i = 0;
        while (i < actualArgs.length) {
            if (!invocationMatcher.getMatchers().get(i).matches(actualArgs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean varArgsMatch(InvocationMatcher invocationMatcher, Invocation actual) {
        List<Matcher> matchers;
        if (!actual.getMethod().isVarArgs()) {
            return false;
        }
        Object[] rawArgs = actual.getRawArguments();
        if (rawArgs.length != (matchers = invocationMatcher.getMatchers()).size()) {
            return false;
        }
        int i = 0;
        while (i < rawArgs.length) {
            Matcher actualMatcher;
            Matcher m = matchers.get(i);
            if (rawArgs[i] != null && rawArgs[i].getClass().isArray() && i == rawArgs.length - 1 ? !((actualMatcher = m instanceof MatcherDecorator ? ((MatcherDecorator)((Object)m)).getActualMatcher() : m) instanceof VarargMatcher) || !actualMatcher.matches(rawArgs[i]) : !m.matches(rawArgs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

