/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.handler;

import java.util.List;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.MatchersBinder;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.internal.stubbing.OngoingStubbingImpl;
import org.mockito.internal.stubbing.StubbedInvocationMatcher;
import org.mockito.internal.stubbing.VoidMethodStubbableImpl;
import org.mockito.internal.verification.MockAwareVerificationMode;
import org.mockito.internal.verification.VerificationDataImpl;
import org.mockito.invocation.Invocation;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.VoidMethodStubbable;
import org.mockito.verification.VerificationMode;

class MockHandlerImpl<T>
implements InternalMockHandler<T> {
    private static final long serialVersionUID = -2917871070982574165L;
    InvocationContainerImpl invocationContainerImpl;
    MatchersBinder matchersBinder = new MatchersBinder();
    MockingProgress mockingProgress = new ThreadSafeMockingProgress();
    private final MockCreationSettings mockSettings;

    public MockHandlerImpl(MockCreationSettings mockSettings) {
        this.mockSettings = mockSettings;
        this.mockingProgress = new ThreadSafeMockingProgress();
        this.matchersBinder = new MatchersBinder();
        this.invocationContainerImpl = new InvocationContainerImpl(this.mockingProgress);
    }

    @Override
    public Object handle(Invocation invocation) throws Throwable {
        if (this.invocationContainerImpl.hasAnswersForStubbing()) {
            InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(this.mockingProgress.getArgumentMatcherStorage(), invocation);
            this.invocationContainerImpl.setMethodForStubbing(invocationMatcher);
            return null;
        }
        VerificationMode verificationMode = this.mockingProgress.pullVerificationMode();
        InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(this.mockingProgress.getArgumentMatcherStorage(), invocation);
        this.mockingProgress.validateState();
        if (verificationMode != null) {
            if (((MockAwareVerificationMode)verificationMode).getMock() == invocation.getMock()) {
                VerificationDataImpl data = new VerificationDataImpl(this.invocationContainerImpl, invocationMatcher);
                verificationMode.verify(data);
                return null;
            }
            this.mockingProgress.verificationStarted(verificationMode);
        }
        this.invocationContainerImpl.setInvocationForPotentialStubbing(invocationMatcher);
        OngoingStubbingImpl ongoingStubbing = new OngoingStubbingImpl(this.invocationContainerImpl);
        this.mockingProgress.reportOngoingStubbing(ongoingStubbing);
        StubbedInvocationMatcher stubbedInvocation = this.invocationContainerImpl.findAnswerFor(invocation);
        if (stubbedInvocation != null) {
            stubbedInvocation.captureArgumentsFrom(invocation);
            return stubbedInvocation.answer(invocation);
        }
        Object ret = this.mockSettings.getDefaultAnswer().answer(invocation);
        this.invocationContainerImpl.resetInvocationForPotentialStubbing(invocationMatcher);
        return ret;
    }

    @Override
    public VoidMethodStubbable<T> voidMethodStubbable(T mock) {
        return new VoidMethodStubbableImpl<T>(mock, this.invocationContainerImpl);
    }

    @Override
    public MockCreationSettings getMockSettings() {
        return this.mockSettings;
    }

    @Override
    public void setAnswersForStubbing(List<Answer> answers) {
        this.invocationContainerImpl.setAnswersForStubbing(answers);
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.invocationContainerImpl;
    }
}

