/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.debugging.WarningsPrinterImpl;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.UnusedStubsFinder;
import org.mockito.internal.invocation.finder.AllInvocationsFinder;
import org.mockito.internal.listeners.CollectCreatedMocks;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.invocation.Invocation;

public class WarningsCollector {
    List createdMocks = new LinkedList();

    public WarningsCollector() {
        ThreadSafeMockingProgress progress = new ThreadSafeMockingProgress();
        progress.setListener(new CollectCreatedMocks(this.createdMocks));
    }

    public String getWarnings() {
        List<Invocation> unused = new UnusedStubsFinder().find(this.createdMocks);
        List<Invocation> all = new AllInvocationsFinder().find(this.createdMocks);
        List<InvocationMatcher> allInvocationMatchers = InvocationMatcher.createFrom(all);
        String warnings = new WarningsPrinterImpl(unused, allInvocationMatchers, false).print();
        return warnings;
    }
}

