/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.mockito.configuration.IMockitoConfiguration;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.exceptions.misusing.MockitoConfigurationException;
import org.mockito.internal.creation.CglibMockMaker;
import org.mockito.internal.exceptions.stacktrace.DefaultStackTraceCleanerProvider;
import org.mockito.plugins.MockMaker;
import org.mockito.plugins.StackTraceCleanerProvider;

public class ClassPathLoader {
    private static final MockMaker mockMaker = ClassPathLoader.findPlatformMockMaker();
    private static final StackTraceCleanerProvider stackTraceCleanerProvider = ClassPathLoader.findPluginImplementation(StackTraceCleanerProvider.class, new DefaultStackTraceCleanerProvider());
    public static final String MOCKITO_CONFIGURATION_CLASS_NAME = "org.mockito.configuration.MockitoConfiguration";

    public IMockitoConfiguration loadConfiguration() {
        Class<?> configClass;
        try {
            configClass = Class.forName(MOCKITO_CONFIGURATION_CLASS_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            return (IMockitoConfiguration)configClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new MockitoConfigurationException("MockitoConfiguration class must implement " + IMockitoConfiguration.class.getName() + " interface.", e);
        }
        catch (Exception e) {
            throw new MockitoConfigurationException("Unable to instantiate org.mockito.configuration.MockitoConfiguration class. Does it have a safe, no-arg constructor?", e);
        }
    }

    public static MockMaker getMockMaker() {
        return mockMaker;
    }

    public static StackTraceCleanerProvider getStackTraceCleanerProvider() {
        return stackTraceCleanerProvider;
    }

    static MockMaker findPlatformMockMaker() {
        return ClassPathLoader.findPluginImplementation(MockMaker.class, new CglibMockMaker());
    }

    static <T> T findPluginImplementation(Class<T> pluginType, T defaultPlugin) {
        Iterator<T> iterator = ClassPathLoader.loadImplementations(pluginType).iterator();
        if (iterator.hasNext()) {
            T plugin = iterator.next();
            return plugin;
        }
        return defaultPlugin;
    }

    static <T> List<T> loadImplementations(Class<T> service) {
        Enumeration<URL> resources;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            resources = loader.getResources("mockito-extensions/" + service.getName());
        }
        catch (IOException e) {
            throw new MockitoException("Failed to load " + service, e);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (URL resource : Collections.list(resources)) {
            InputStream in = null;
            try {
                try {
                    in = resource.openStream();
                    for (String line : ClassPathLoader.readerToLines(new InputStreamReader(in, "UTF-8"))) {
                        String name = ClassPathLoader.stripCommentAndWhitespace(line);
                        if (name.length() == 0) continue;
                        result.add(service.cast(loader.loadClass(name).newInstance()));
                    }
                }
                catch (Exception e) {
                    throw new MockitoConfigurationException("Failed to load " + service + " using " + resource, e);
                }
            }
            finally {
                ClassPathLoader.closeQuietly(in);
            }
        }
        return result;
    }

    static List<String> readerToLines(Reader reader) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader lineReader = new BufferedReader(reader);
        while ((line = lineReader.readLine()) != null) {
            result.add(line);
        }
        return result;
    }

    static String stripCommentAndWhitespace(String line) {
        int hash = line.indexOf(35);
        if (hash != -1) {
            line = line.substring(0, hash);
        }
        return line.trim();
    }

    private static void closeQuietly(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

