/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal;

import java.util.Arrays;
import java.util.List;
import org.mockito.InOrder;
import org.mockito.MockSettings;
import org.mockito.MockingDetails;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.internal.InOrderImpl;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.invocation.finder.VerifiableInvocationsFinder;
import org.mockito.internal.progress.IOngoingStubbing;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.stubbing.OngoingStubbingImpl;
import org.mockito.internal.stubbing.StubberImpl;
import org.mockito.internal.util.DefaultMockingDetails;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.verification.MockAwareVerificationMode;
import org.mockito.internal.verification.VerificationDataImpl;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.internal.verification.api.VerificationDataInOrderImpl;
import org.mockito.invocation.Invocation;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.DeprecatedOngoingStubbing;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.stubbing.VoidMethodStubbable;
import org.mockito.verification.VerificationMode;

public class MockitoCore {
    private final Reporter reporter = new Reporter();
    private final MockUtil mockUtil = new MockUtil();
    private final MockingProgress mockingProgress = new ThreadSafeMockingProgress();

    public <T> T mock(Class<T> typeToMock, MockSettings settings) {
        if (!MockSettingsImpl.class.isInstance(settings)) {
            throw new IllegalArgumentException("Unexpected implementation of '" + settings.getClass().getCanonicalName() + "'\n" + "At the moment, you cannot provide your own implementations that class.");
        }
        MockSettingsImpl impl = (MockSettingsImpl)MockSettingsImpl.class.cast(settings);
        MockCreationSettings<T> creationSettings = impl.confirm(typeToMock);
        T mock = this.mockUtil.createMock(creationSettings);
        this.mockingProgress.mockingStarted(mock, typeToMock);
        return mock;
    }

    public IOngoingStubbing stub() {
        IOngoingStubbing stubbing = this.mockingProgress.pullOngoingStubbing();
        if (stubbing == null) {
            this.mockingProgress.reset();
            this.reporter.missingMethodInvocation();
        }
        return stubbing;
    }

    public <T> DeprecatedOngoingStubbing<T> stub(T methodCall) {
        this.mockingProgress.stubbingStarted();
        return (DeprecatedOngoingStubbing)this.stub();
    }

    public <T> OngoingStubbing<T> when(T methodCall) {
        this.mockingProgress.stubbingStarted();
        return (OngoingStubbing)this.stub();
    }

    public <T> T verify(T mock, VerificationMode mode) {
        if (mock == null) {
            this.reporter.nullPassedToVerify();
        } else if (!this.mockUtil.isMock(mock)) {
            this.reporter.notAMockPassedToVerify(mock.getClass());
        }
        this.mockingProgress.verificationStarted(new MockAwareVerificationMode(mock, mode));
        return mock;
    }

    public <T> void reset(T ... mocks) {
        this.mockingProgress.validateState();
        this.mockingProgress.reset();
        this.mockingProgress.resetOngoingStubbing();
        T[] TArray = mocks;
        int n = mocks.length;
        int n2 = 0;
        while (n2 < n) {
            T m = TArray[n2];
            this.mockUtil.resetMock(m);
            ++n2;
        }
    }

    public void verifyNoMoreInteractions(Object ... mocks) {
        this.assertMocksNotEmpty(mocks);
        this.mockingProgress.validateState();
        Object[] objectArray = mocks;
        int n = mocks.length;
        int n2 = 0;
        while (n2 < n) {
            Object mock = objectArray[n2];
            try {
                if (mock == null) {
                    this.reporter.nullPassedToVerifyNoMoreInteractions();
                }
                InvocationContainer invocations = this.mockUtil.getMockHandler(mock).getInvocationContainer();
                VerificationDataImpl data = new VerificationDataImpl(invocations, null);
                VerificationModeFactory.noMoreInteractions().verify(data);
            }
            catch (NotAMockException notAMockException) {
                this.reporter.notAMockPassedToVerifyNoMoreInteractions();
            }
            ++n2;
        }
    }

    public void verifyNoMoreInteractionsInOrder(List<Object> mocks, InOrderContext inOrderContext) {
        this.mockingProgress.validateState();
        VerifiableInvocationsFinder finder = new VerifiableInvocationsFinder();
        VerificationDataInOrderImpl data = new VerificationDataInOrderImpl(inOrderContext, finder.find(mocks), null);
        VerificationModeFactory.noMoreInteractions().verifyInOrder(data);
    }

    private void assertMocksNotEmpty(Object[] mocks) {
        if (mocks == null || mocks.length == 0) {
            this.reporter.mocksHaveToBePassedToVerifyNoMoreInteractions();
        }
    }

    public InOrder inOrder(Object ... mocks) {
        if (mocks == null || mocks.length == 0) {
            this.reporter.mocksHaveToBePassedWhenCreatingInOrder();
        }
        Object[] objectArray = mocks;
        int n = mocks.length;
        int n2 = 0;
        while (n2 < n) {
            Object mock = objectArray[n2];
            if (mock == null) {
                this.reporter.nullPassedWhenCreatingInOrder();
            } else if (!this.mockUtil.isMock(mock)) {
                this.reporter.notAMockPassedWhenCreatingInOrder();
            }
            ++n2;
        }
        return new InOrderImpl(Arrays.asList(mocks));
    }

    public Stubber doAnswer(Answer answer) {
        this.mockingProgress.stubbingStarted();
        this.mockingProgress.resetOngoingStubbing();
        return new StubberImpl().doAnswer(answer);
    }

    public <T> VoidMethodStubbable<T> stubVoid(T mock) {
        InternalMockHandler<T> handler = this.mockUtil.getMockHandler(mock);
        this.mockingProgress.stubbingStarted();
        return handler.voidMethodStubbable(mock);
    }

    public void validateMockitoUsage() {
        this.mockingProgress.validateState();
    }

    public Invocation getLastInvocation() {
        OngoingStubbingImpl ongoingStubbing = (OngoingStubbingImpl)this.mockingProgress.pullOngoingStubbing();
        List<Invocation> allInvocations = ongoingStubbing.getRegisteredInvocations();
        return allInvocations.get(allInvocations.size() - 1);
    }

    public Object[] ignoreStubs(Object ... mocks) {
        Object[] objectArray = mocks;
        int n = mocks.length;
        int n2 = 0;
        while (n2 < n) {
            Object m = objectArray[n2];
            InvocationContainer invocationContainer = new MockUtil().getMockHandler(m).getInvocationContainer();
            List<Invocation> ins = invocationContainer.getInvocations();
            for (Invocation in : ins) {
                if (in.stubInfo() == null) continue;
                in.ignoreForVerification();
            }
            ++n2;
        }
        return mocks;
    }

    public MockingDetails mockingDetails(Object toInspect) {
        return new DefaultMockingDetails(toInspect, new MockUtil());
    }
}

