/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.DoubleSortComparer;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class FloatValue
extends NumericValue {
    public static final FloatValue ZERO = new FloatValue(0.0f);
    public static final FloatValue NEGATIVE_ZERO = new FloatValue(-0.0f);
    public static final FloatValue ONE = new FloatValue(1.0f);
    public static final FloatValue NaN = new FloatValue(Float.NaN);
    private float value;
    static Pattern roundablePattern = Pattern.compile(".*99999.*|.*00000.*");

    public FloatValue(CharSequence val) throws ValidationException {
        try {
            this.value = (float)Value.stringToNumber(val);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException("Cannot convert string " + Err.wrap(val, 4) + " to a float");
        }
        this.typeLabel = BuiltInAtomicType.FLOAT;
    }

    public FloatValue(float value) {
        this.value = value;
        this.typeLabel = BuiltInAtomicType.FLOAT;
    }

    public FloatValue(float value, AtomicType type) {
        this.value = value;
        this.typeLabel = type;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        FloatValue v = new FloatValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.FLOAT;
    }

    @Override
    public float getFloatValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return (int)this.value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    @Override
    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    @Override
    public boolean effectiveBooleanValue() {
        return (double)this.value != 0.0 && !Float.isNaN(this.value);
    }

    @Override
    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getFingerprint()) {
            case 514: {
                return BooleanValue.get((double)this.value != 0.0 && !Float.isNaN(this.value));
            }
            case 516: 
            case 632: 
            case 635: {
                return this;
            }
            case 532: {
                if (Float.isNaN(this.value)) {
                    ValidationFailure err = new ValidationFailure("Cannot convert float NaN to an integer");
                    err.setErrorCode("FOCA0002");
                    return err;
                }
                if (Float.isInfinite(this.value)) {
                    ValidationFailure err = new ValidationFailure("Cannot convert float infinity to an integer");
                    err.setErrorCode("FOCA0002");
                    return err;
                }
                if (this.value > 9.223372E18f || this.value < -9.223372E18f) {
                    return new BigIntegerValue(new BigDecimal(this.value).toBigInteger());
                }
                return Int64Value.makeIntegerValue((long)this.value);
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                ConversionResult iv = this.convertPrimitive(BuiltInAtomicType.INTEGER, validate, context);
                if (iv instanceof ValidationFailure) {
                    return iv;
                }
                return ((IntegerValue)iv).convertPrimitive(requiredType, validate, context);
            }
            case 515: {
                try {
                    return new DecimalValue(this.value);
                }
                catch (ValidationException e) {
                    return new ValidationFailure(e);
                }
            }
            case 517: {
                return new DoubleValue(this.value);
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert float to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        return FloatValue.floatToString(this.value);
    }

    @Override
    public CharSequence getCanonicalLexicalRepresentation() {
        FastStringBuffer fsb = new FastStringBuffer(16);
        return FloatingPointConverter.appendFloatExponential(fsb, this.value);
    }

    static CharSequence floatToString(float value) {
        return FloatingPointConverter.appendFloat(new FastStringBuffer(16), value);
    }

    @Override
    public NumericValue negate() {
        return new FloatValue(-this.value);
    }

    @Override
    public NumericValue floor() {
        return new FloatValue((float)Math.floor(this.value));
    }

    @Override
    public NumericValue ceiling() {
        return new FloatValue((float)Math.ceil(this.value));
    }

    @Override
    public NumericValue round() {
        if (Float.isNaN(this.value)) {
            return this;
        }
        if (Float.isInfinite(this.value)) {
            return this;
        }
        if ((double)this.value == 0.0) {
            return this;
        }
        if ((double)this.value >= -0.5 && (double)this.value < 0.0) {
            return new FloatValue(-0.0f);
        }
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return new FloatValue(Math.round(this.value));
        }
        return this;
    }

    @Override
    public NumericValue roundHalfToEven(int scale) {
        try {
            return (FloatValue)new DoubleValue(this.value).roundHalfToEven(scale).convertPrimitive(BuiltInAtomicType.FLOAT, true, null).asAtomic();
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    @Override
    public double signum() {
        if (Float.isNaN(this.value)) {
            return this.value;
        }
        if (this.value > 0.0f) {
            return 1.0;
        }
        if (this.value == 0.0f) {
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public boolean isWholeNumber() {
        return (double)this.value == Math.floor(this.value) && !Float.isInfinite(this.value);
    }

    @Override
    public NumericValue abs() {
        if ((double)this.value > 0.0) {
            return this;
        }
        return new FloatValue(Math.abs(this.value));
    }

    @Override
    public int compareTo(Object other) {
        if (!(other instanceof NumericValue)) {
            throw new ClassCastException("Numeric values are not comparable to " + other.getClass());
        }
        if (other instanceof FloatValue) {
            float otherFloat = ((FloatValue)other).value;
            if (this.value == otherFloat) {
                return 0;
            }
            if (this.value < otherFloat) {
                return -1;
            }
            return 1;
        }
        if (other instanceof DoubleValue) {
            return super.compareTo(other);
        }
        try {
            return this.compareTo(((NumericValue)other).convertPrimitive(BuiltInAtomicType.FLOAT, true, null).asAtomic());
        }
        catch (XPathException xPathException) {
            throw new ClassCastException("Operand of comparison cannot be promoted to xs:float");
        }
    }

    @Override
    public int compareTo(long other) {
        float otherFloat = other;
        if (this.value == otherFloat) {
            return 0;
        }
        if (this.value < otherFloat) {
            return -1;
        }
        return 1;
    }

    @Override
    public Comparable getSchemaComparable() {
        return new Float(this.value);
    }

    @Override
    public boolean isIdentical(Value v) {
        return v instanceof FloatValue && DoubleSortComparer.getInstance().comparesEqual(this, (FloatValue)v);
    }
}

