/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;
import net.sf.saxon.type.TypeHierarchy;

final class AttributeImpl
extends NodeImpl {
    public AttributeImpl(ElementImpl element, int index) {
        this.parent = element;
        this.index = index;
    }

    @Override
    public int getNameCode() {
        if (this.parent == null || this.index == -1) {
            return -1;
        }
        return ((ElementImpl)this.parent).getAttributeList().getNameCode(this.index);
    }

    @Override
    public int getTypeAnnotation() {
        return ((ElementImpl)this.parent).getAttributeList().getTypeAnnotation(this.index);
    }

    @Override
    public boolean isId() {
        if (this.getFingerprint() == 388) {
            return true;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return th.isIdCode(this.getTypeAnnotation());
    }

    @Override
    public boolean isIdref() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return th.isIdrefsCode(this.getTypeAnnotation());
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof AttributeImpl)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        AttributeImpl otherAtt = (AttributeImpl)other;
        return this.parent.isSameNodeInfo(otherAtt.parent) && this.index == otherAtt.index;
    }

    @Override
    public int hashCode() {
        return this.parent.hashCode() ^ this.index << 16;
    }

    @Override
    protected long getSequenceNumber() {
        long parseq = this.parent.getSequenceNumber();
        return parseq == -1L ? parseq : parseq + 32768L + (long)this.index;
    }

    @Override
    public final int getNodeKind() {
        return 2;
    }

    @Override
    public String getStringValue() {
        return ((ElementImpl)this.parent).getAttributeList().getValue(this.index);
    }

    @Override
    public NodeInfo getNextSibling() {
        return null;
    }

    @Override
    public NodeInfo getPreviousSibling() {
        return null;
    }

    @Override
    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    @Override
    public NodeImpl getNextInDocument(NodeImpl anchor) {
        if (anchor == this) {
            return null;
        }
        return ((NodeImpl)this.getParent()).getNextInDocument(anchor);
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        this.getParent().generateId(buffer);
        buffer.append('a');
        buffer.append(Integer.toString(this.index));
    }

    @Override
    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        int nameCode = this.getNameCode();
        int typeCode = copyAnnotations ? this.getTypeAnnotation() : -1;
        out.attribute(nameCode, typeCode, this.getStringValue(), locationId, 0);
    }

    @Override
    public void delete() {
        if (this.parent != null) {
            this.parent.removeAttribute(this);
        }
        this.parent = null;
        this.index = -1;
    }

    @Override
    public boolean isDeleted() {
        return this.index == -1 || this.getNameCode() == -1 || this.parent != null && this.parent.isDeleted();
    }

    @Override
    public void replace(NodeInfo[] replacement, boolean inherit) {
        ParentNodeImpl element = this.parent;
        this.delete();
        int i = 0;
        while (i < replacement.length) {
            NodeInfo n = replacement[i];
            if (n.getNodeKind() != 2) {
                throw new IllegalArgumentException("Replacement nodes must be attributes");
            }
            element.addAttribute(n.getNameCode(), 631, n.getStringValue(), 0);
            ++i;
        }
    }

    @Override
    public void rename(int newNameCode) {
        if (this.parent != null) {
            ((AttributeCollectionImpl)((ElementImpl)this.parent).getAttributeList()).renameAttribute(this.index, newNameCode);
            if (newNameCode >> 20 != 0) {
                int nscode = this.getNamePool().getNamespaceCode(newNameCode);
                int prefixCode = nscode >> 16 & 0xFFFF;
                short uc = ((ElementImpl)this.parent).getURICodeForPrefixCode(prefixCode);
                if (uc == -1) {
                    this.parent.addNamespace(nscode, false);
                } else if (uc != (nscode & 0xFFFF)) {
                    throw new IllegalArgumentException("Namespace binding of new name conflicts with existing namespace binding");
                }
            }
        }
    }

    @Override
    public void replaceStringValue(CharSequence stringValue) {
        if (this.parent != null) {
            AttributeCollectionImpl atts = (AttributeCollectionImpl)((ElementImpl)this.parent).getAttributeList();
            atts.replaceAttribute(this.index, stringValue);
        }
    }

    @Override
    public void removeTypeAnnotation() {
        if (this.parent != null) {
            AttributeCollectionImpl atts = (AttributeCollectionImpl)((ElementImpl)this.parent).getAttributeList();
            atts.setTypeAnnotation(this.index, 631);
            this.parent.removeTypeAnnotation();
        }
    }

    @Override
    public void setTypeAnnotation(int typeCode) {
        if (this.parent != null) {
            AttributeCollectionImpl atts = (AttributeCollectionImpl)((ElementImpl)this.parent).getAttributeList();
            atts.setTypeAnnotation(this.index, typeCode);
        }
    }
}

