/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import net.sf.saxon.trans.XPathException;

public class DynamicLoader {
    private ClassLoader classLoader;

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class getClass(String className, boolean tracing, ClassLoader classLoader) throws XPathException {
        if (tracing) {
            System.err.println("Loading " + className);
        }
        try {
            ClassLoader loader = classLoader;
            if (loader == null) {
                loader = this.classLoader;
            }
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            if (loader != null) {
                try {
                    return loader.loadClass(className);
                }
                catch (Exception exception) {
                    return Class.forName(className);
                }
            }
            return Class.forName(className);
        }
        catch (Exception e) {
            if (tracing) {
                System.err.println("The class " + className + " could not be loaded");
            }
            throw new XPathException("Failed to load " + className, e);
        }
    }

    public Object getInstance(String className, ClassLoader classLoader) throws XPathException {
        Class theclass = this.getClass(className, false, classLoader);
        try {
            return theclass.newInstance();
        }
        catch (Exception err) {
            throw new XPathException("Failed to instantiate class " + className + " (does it have a public zero-argument constructor?)", err);
        }
    }

    public Object getInstance(String className, boolean tracing, ClassLoader classLoader) throws XPathException {
        Class theclass = this.getClass(className, tracing, classLoader);
        try {
            return theclass.newInstance();
        }
        catch (NoClassDefFoundError err) {
            throw new XPathException("Failed to load instance of class " + className, err);
        }
        catch (Exception err) {
            throw new XPathException("Failed to instantiate class " + className, err);
        }
    }
}

