/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.util.Iterator;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.CallTemplate;
import net.sf.saxon.instruct.ForEach;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.trace.ContextStackFrame;
import net.sf.saxon.trace.InstructionInfo;

public class ContextStackIterator
implements Iterator {
    private boolean first = true;
    private XPathContext next;

    public ContextStackIterator(XPathContext context) {
        this.next = context;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        XPathContext context = this.next;
        if (context == null) {
            return null;
        }
        int construct = context.getOriginatingConstructType();
        InstructionInfo origin = context.getOrigin();
        if (!this.first || construct == 2024 || construct == 2025 || construct != 2061) {
            // empty if block
        }
        if (construct == 2000) {
            this.next = context.getCaller();
            return new ContextStackFrame.CallingApplication();
        }
        if (construct == 2010) {
            this.next = context.getCaller();
            return new ContextStackFrame.BuiltInTemplateRule();
        }
        if (construct == 2009) {
            ContextStackFrame.FunctionCall sf = new ContextStackFrame.FunctionCall();
            UserFunctionCall ufc = (UserFunctionCall)origin;
            sf.setSystemId(ufc.getSystemId());
            sf.setLineNumber(ufc.getLineNumber());
            sf.setContainer(ufc.getContainer());
            sf.setFunctionName(ufc.getFunctionName());
            sf.setContextItem(context.getContextItem());
            this.next = context.getCaller();
            return sf;
        }
        if (construct == 130) {
            ContextStackFrame.ApplyTemplates sf = new ContextStackFrame.ApplyTemplates();
            ApplyTemplates loc = (ApplyTemplates)origin;
            sf.setSystemId(loc.getSystemId());
            sf.setLineNumber(loc.getLineNumber());
            sf.setContainer(loc.getContainer());
            sf.setContextItem(context.getContextItem());
            this.next = context.getCaller();
            return sf;
        }
        if (construct == 133) {
            ContextStackFrame.CallTemplate sf = new ContextStackFrame.CallTemplate();
            CallTemplate loc = (CallTemplate)origin;
            sf.setSystemId(loc.getSystemId());
            sf.setLineNumber(loc.getLineNumber());
            sf.setContainer(loc.getContainer());
            sf.setTemplateName(loc.getObjectName());
            sf.setContextItem(context.getContextItem());
            this.next = context.getCaller();
            return sf;
        }
        if (construct == 185) {
            ContextStackFrame.VariableEvaluation sf = new ContextStackFrame.VariableEvaluation();
            GeneralVariable var = (GeneralVariable)origin;
            sf.setSystemId(var.getSystemId());
            sf.setLineNumber(var.getLineNumber());
            sf.setContainer(var.getContainer());
            sf.setContextItem(context.getContextItem());
            sf.setVariableName(var.getVariableQName());
            this.next = context.getCaller();
            return sf;
        }
        if (construct == 145) {
            ContextStackFrame.ForEach sf = new ContextStackFrame.ForEach();
            ForEach var = (ForEach)origin;
            sf.setSystemId(var.getSystemId());
            sf.setLineNumber(var.getLineNumber());
            sf.setContainer(var.getContainer());
            sf.setContextItem(context.getContextItem());
            this.next = context.getCaller();
            return sf;
        }
        this.next = context.getCaller();
        return this.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

