/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.io.PrintStream;
import net.sf.saxon.expr.Container;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.KeyDefinition;

public abstract class ContextStackFrame {
    private String moduleUri;
    private int lineNumber;
    private Container container;
    private Item contextItem;

    public void setSystemId(String uri) {
        this.moduleUri = uri;
    }

    public String getSystemId() {
        return this.moduleUri;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContextItem(Item contextItem) {
        this.contextItem = contextItem;
    }

    public Item getContextItem() {
        return this.contextItem;
    }

    public abstract void print(PrintStream var1);

    protected String showLocation() {
        if (this.getSystemId() == null) {
            return "";
        }
        int line = this.getLineNumber();
        if (line == -1 || line == 1048575) {
            return "(" + this.getSystemId() + ")";
        }
        return "(" + this.getSystemId() + "#" + this.getLineNumber() + ")";
    }

    private static String displayContainer(Container container) {
        if (container instanceof Procedure) {
            String objectName;
            StructuredQName name = ((Procedure)container).getObjectName();
            String string = objectName = name == null ? "" : name.getDisplayName();
            if (container instanceof Template) {
                if (name == null) {
                    return "template match=\"" + ((Template)container).getMatchPattern().toString() + "\"";
                }
                return "template name=\"" + objectName + "\"";
            }
            if (container instanceof UserFunction) {
                return "function " + objectName + "()";
            }
            if (container instanceof AttributeSet) {
                return "attribute-set " + objectName;
            }
            if (container instanceof KeyDefinition) {
                return "key " + objectName;
            }
        } else {
            if (container instanceof GlobalVariable) {
                StructuredQName qName = ((GlobalVariable)container).getVariableQName();
                if ("http://saxon.sf.net/".equals(qName.getNamespaceURI()) && "gg".equals(qName.getPrefix())) {
                    return "optimizer-created global variable";
                }
                return "variable " + qName.getDisplayName();
            }
            return "";
        }
        return "";
    }

    public static class ApplyTemplates
    extends ContextStackFrame {
        @Override
        public void print(PrintStream out) {
            out.println("  at xsl:apply-templates " + this.showLocation());
            Item node = this.getContextItem();
            if (node instanceof NodeInfo) {
                out.println("     processing " + Navigator.getPath((NodeInfo)node));
            }
        }
    }

    public static class BuiltInTemplateRule
    extends ContextStackFrame {
        @Override
        public void print(PrintStream out) {
            out.println("  in built-in template rule");
        }
    }

    public static class CallTemplate
    extends ContextStackFrame {
        StructuredQName templateName;

        public StructuredQName getTemplateName() {
            return this.templateName;
        }

        public void setTemplateName(StructuredQName templateName) {
            this.templateName = templateName;
        }

        @Override
        public void print(PrintStream out) {
            String name = this.templateName == null ? "??" : this.templateName.getDisplayName();
            out.println("  at xsl:call-template name=\"" + name + "\" " + this.showLocation());
        }
    }

    public static class CallingApplication
    extends ContextStackFrame {
        @Override
        public void print(PrintStream out) {
        }
    }

    public static class ForEach
    extends ContextStackFrame {
        @Override
        public void print(PrintStream out) {
            out.println("  at xsl:for-each " + this.showLocation());
            Item item = this.getContextItem();
            if (item instanceof NodeInfo) {
                out.println("     processing " + Navigator.getPath((NodeInfo)item));
            } else {
                out.println("     processing " + Err.wrap(item.getStringValueCS(), 4));
            }
        }
    }

    public static class FunctionCall
    extends ContextStackFrame {
        StructuredQName functionName;

        public StructuredQName getFunctionName() {
            return this.functionName;
        }

        public void setFunctionName(StructuredQName functionName) {
            this.functionName = functionName;
        }

        @Override
        public void print(PrintStream out) {
            out.println("  at " + (this.functionName == null ? "(anonymous)" : this.functionName.getDisplayName()) + "() " + this.showLocation());
        }
    }

    public static class VariableEvaluation
    extends ContextStackFrame {
        StructuredQName variableName;

        public StructuredQName getVariableName() {
            return this.variableName;
        }

        public void setVariableName(StructuredQName variableName) {
            this.variableName = variableName;
        }

        @Override
        public void print(PrintStream out) {
            out.println("  in " + ContextStackFrame.displayContainer(this.getContainer()) + " " + this.showLocation());
        }
    }
}

