/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyNodeImpl;

final class AncestorEnumeration
extends AxisIteratorImpl {
    private TinyNodeImpl startNode;
    private NodeTest test;
    private boolean includeSelf;

    public AncestorEnumeration(TinyNodeImpl node, NodeTest nodeTest, boolean includeSelf) {
        this.test = nodeTest;
        this.startNode = node;
        this.includeSelf = includeSelf;
        this.current = this.startNode;
    }

    @Override
    public Item next() {
        if (this.position <= 0) {
            if (this.position < 0) {
                return null;
            }
            if (this.position == 0 && this.includeSelf && this.test.matches(this.startNode)) {
                this.current = this.startNode;
                this.position = 1;
                return this.current;
            }
        }
        NodeInfo node = this.current.getParent();
        while (node != null && !this.test.matches(node)) {
            node = node.getParent();
        }
        this.current = node;
        this.position = node == null ? -1 : ++this.position;
        return this.current;
    }

    @Override
    public SequenceIterator getAnother() {
        return new AncestorEnumeration(this.startNode, this.test, this.includeSelf);
    }
}

