/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.type.BuiltInAtomicType;

public abstract class AbstractStaticContext
implements StaticContext {
    private String baseURI = null;
    private Configuration config;
    private LocationMap locationMap = new LocationMap();
    private Executable executable;
    private String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
    private String defaultElementNamespace = "";
    private boolean backwardsCompatible = false;

    protected void setConfiguration(Configuration config) {
        this.config = config;
        this.executable = new Executable(config);
        this.executable.setCollationTable(new CollationMap(config.getCollationMap()));
        this.executable.setHostLanguage(54);
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    protected final void setDefaultFunctionLibrary() {
        FunctionLibraryList lib = new FunctionLibraryList();
        lib.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(1));
        lib.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        lib.addFunctionLibrary(this.config.getIntegratedFunctionLibrary());
        this.config.addExtensionBinders(lib);
        this.setFunctionLibrary(lib);
    }

    protected final void addFunctionLibrary(FunctionLibrary library) {
        FunctionLibrary libraryList = this.executable.getFunctionLibrary();
        if (!(libraryList instanceof FunctionLibraryList)) {
            throw new IllegalStateException("Registered function library cannot be extended");
        }
        ((FunctionLibraryList)libraryList).addFunctionLibrary(library);
    }

    @Override
    public Executable getExecutable() {
        return this.executable;
    }

    public int getHostLanguage() {
        return 54;
    }

    @Override
    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration(), this.executable.getCollationTable());
    }

    @Override
    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.executable.getFunctionLibrary();
    }

    public void setFunctionLibrary(FunctionLibrary lib) {
        this.executable.setFunctionLibrary(lib);
    }

    public void declareCollation(String name, StringCollator comparator, boolean isDefault) {
        CollationMap collations = this.executable.getCollationTable();
        collations.setNamedCollation(name, comparator);
        if (isDefault) {
            collations.setDefaultCollationName(name);
        }
    }

    @Override
    public StringCollator getCollation(String name) {
        return this.executable.getCollationTable().getNamedCollation(name);
    }

    @Override
    public String getDefaultCollationName() {
        return this.executable.getCollationTable().getDefaultCollationName();
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    @Override
    public void issueWarning(String s, SourceLocator locator) {
        System.err.println("Warning: " + s);
    }

    @Override
    public String getSystemId() {
        return "";
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setDefaultElementNamespace(String uri) {
        this.defaultElementNamespace = uri;
    }

    public void setDefaultFunctionNamespace(String uri) {
        this.defaultFunctionNamespace = uri;
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setBackwardsCompatibilityMode(boolean compatible) {
        this.backwardsCompatible = compatible;
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return this.backwardsCompatible;
    }

    @Override
    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        return type.getFingerprint() != 565 || this.config.getXsdVersion() == Configuration.XSD11;
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        return null;
    }

    public LocationProvider getLocationProvider() {
        return this.locationMap;
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }
}

