/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLSort
extends StyleElement {
    private SortKeyDefinition sortKeyDefinition;
    private Expression select;
    private Expression order;
    private Expression dataType = null;
    private Expression caseOrder;
    private Expression lang;
    private Expression collationName;
    private Expression stable;
    private boolean useDefaultCollation = true;

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String orderAtt = null;
        String dataTypeAtt = null;
        String caseOrderAtt = null;
        String langAtt = null;
        String collationAtt = null;
        String stableAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "select") {
                selectAtt = atts.getValue(a);
            } else if (f == "order") {
                orderAtt = Whitespace.trim(atts.getValue(a));
            } else if (f == "data-type") {
                dataTypeAtt = Whitespace.trim(atts.getValue(a));
            } else if (f == "case-order") {
                caseOrderAtt = Whitespace.trim(atts.getValue(a));
            } else if (f == "lang") {
                langAtt = Whitespace.trim(atts.getValue(a));
            } else if (f == "collation") {
                collationAtt = Whitespace.trim(atts.getValue(a));
            } else if (f == "stable") {
                stableAtt = Whitespace.trim(atts.getValue(a));
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
        this.order = orderAtt == null ? new StringLiteral("ascending") : this.makeAttributeValueTemplate(orderAtt);
        this.dataType = dataTypeAtt == null ? null : this.makeAttributeValueTemplate(dataTypeAtt);
        if (caseOrderAtt == null) {
            this.caseOrder = new StringLiteral("#default");
        } else {
            this.caseOrder = this.makeAttributeValueTemplate(caseOrderAtt);
            this.useDefaultCollation = false;
        }
        if (langAtt == null) {
            this.lang = new StringLiteral(StringValue.EMPTY_STRING);
        } else if (langAtt.equals("")) {
            this.compileError("The lang attribute must be a valid language code", "XTDE0030");
        } else {
            this.lang = this.makeAttributeValueTemplate(langAtt);
            this.useDefaultCollation = false;
        }
        this.stable = stableAtt == null ? null : this.makeAttributeValueTemplate(stableAtt);
        if (collationAtt != null) {
            this.collationName = this.makeAttributeValueTemplate(collationAtt);
            this.useDefaultCollation = false;
        }
    }

    @Override
    public void validate() throws XPathException {
        if (this.select != null && this.hasChildNodes()) {
            this.compileError("An xsl:sort element with a select attribute must be empty", "XTSE1015");
        }
        if (this.select == null && !this.hasChildNodes()) {
            this.select = new ContextItemExpression();
        }
        if (this.useDefaultCollation) {
            this.collationName = new StringLiteral(this.getDefaultCollationName());
        }
        StringCollator stringCollator = null;
        if (this.collationName instanceof StringLiteral) {
            String collationString = ((StringLiteral)this.collationName).getStringValue();
            try {
                URI collationURI = new URI(collationString);
                if (!collationURI.isAbsolute()) {
                    URI base = new URI(this.getBaseURI());
                    collationURI = base.resolve(collationURI);
                    collationString = collationURI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.compileError("Collation name '" + collationString + "' is not a valid URI");
                collationString = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
            if ((stringCollator = this.getPrincipalStylesheet().findCollation(collationString)) == null) {
                this.compileError("Collation " + collationString + " has not been defined", "XTDE1035");
                stringCollator = CodepointCollator.getInstance();
            }
        }
        this.select = this.typeCheck("select", this.select);
        this.order = this.typeCheck("order", this.order);
        this.caseOrder = this.typeCheck("case-order", this.caseOrder);
        this.lang = this.typeCheck("lang", this.lang);
        this.dataType = this.typeCheck("data-type", this.dataType);
        this.collationName = this.typeCheck("collation", this.collationName);
        this.stable = this.typeCheck("stable", this.stable);
        if (this.select != null) {
            try {
                RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:sort/select"), 0);
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.ATOMIC_SEQUENCE, false, role, this.makeExpressionVisitor());
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
        this.sortKeyDefinition = new SortKeyDefinition();
        this.sortKeyDefinition.setOrder(this.order);
        this.sortKeyDefinition.setCaseOrder(this.caseOrder);
        this.sortKeyDefinition.setLanguage(this.lang);
        this.sortKeyDefinition.setSortKey(this.select);
        this.sortKeyDefinition.setDataTypeExpression(this.dataType);
        this.sortKeyDefinition.setCollationNameExpression(this.collationName);
        this.sortKeyDefinition.setCollation(stringCollator);
        this.sortKeyDefinition.setBaseURI(this.getBaseURI());
        this.sortKeyDefinition.setStable(this.stable);
        this.sortKeyDefinition.setBackwardsCompatible(this.backwardsCompatibleModeIsEnabled());
    }

    @Override
    protected ItemType getReturnedItemType() {
        return null;
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        if (this.select == null) {
            Expression b = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
            b.setContainer(this);
            if (b == null) {
                b = new Literal(EmptySequence.getInstance());
            }
            try {
                ExpressionVisitor visitor = this.makeExpressionVisitor();
                Expression atomizedSortKey = new Atomizer(b);
                atomizedSortKey = visitor.simplify(atomizedSortKey);
                ExpressionTool.copyLocationInfo(b, atomizedSortKey);
                this.sortKeyDefinition.setSortKey(atomizedSortKey);
            }
            catch (XPathException e) {
                this.compileError(e);
            }
        }
        this.sortKeyDefinition = this.sortKeyDefinition.simplify(this.makeExpressionVisitor());
        return null;
    }

    public SortKeyDefinition getSortKeyDefinition() {
        return this.sortKeyDefinition;
    }

    public Expression getStable() {
        return this.stable;
    }
}

