/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Value;

public class XSLIf
extends StyleElement {
    private Expression test;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String testAtt = null;
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "test") {
                testAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (testAtt == null) {
            this.reportAbsence("test");
        } else {
            this.test = this.makeExpression(testAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        this.test = this.typeCheck("test", this.test);
    }

    @Override
    public boolean markTailCalls() {
        StyleElement last = this.getLastChildInstruction();
        return last != null && last.markTailCalls();
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        Expression action;
        if (this.test instanceof Literal) {
            Value testVal = ((Literal)this.test).getValue();
            try {
                if (testVal.effectiveBooleanValue()) {
                    return this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
                }
                return null;
            }
            catch (XPathException xPathException) {}
        }
        if ((action = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true)) == null) {
            return null;
        }
        Expression[] conditions = new Expression[]{this.test};
        Expression[] actions = new Expression[]{action};
        Choose inst = new Choose(conditions, actions);
        return inst;
    }
}

