/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.sort.StringCollator;

public class UppercaseFirstCollator
implements StringCollator,
Serializable {
    private StringCollator baseCollator;

    public UppercaseFirstCollator(StringCollator base) {
        this.baseCollator = base;
    }

    @Override
    public int compareStrings(String a, String b) {
        int diff = this.baseCollator.compareStrings(a, b);
        if (diff != 0) {
            return diff;
        }
        int i = 0;
        int j = 0;
        while (true) {
            if (i < a.length() && j < b.length() && a.charAt(i) == b.charAt(j)) {
                ++i;
                ++j;
                continue;
            }
            while (i < a.length() && !Character.isLetter(a.charAt(i))) {
                ++i;
            }
            while (j < b.length() && !Character.isLetter(b.charAt(j))) {
                ++j;
            }
            if (i >= a.length()) {
                return 0;
            }
            if (j >= b.length()) {
                return 0;
            }
            boolean aUpper = Character.isUpperCase(a.charAt(i++));
            boolean bUpper = Character.isUpperCase(b.charAt(j++));
            if (aUpper && !bUpper) {
                return -1;
            }
            if (bUpper && !aUpper) break;
        }
        return 1;
    }

    @Override
    public boolean comparesEqual(String s1, String s2) {
        return this.compareStrings(s1, s2) == 0;
    }

    @Override
    public Object getCollationKey(String s) {
        return this.baseCollator.getCollationKey(s);
    }
}

