/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class GroupByIterator
implements GroupIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator population;
    protected Expression keyExpression;
    private StringCollator collator;
    private XPathContext keyContext;
    private int position = 0;
    protected List<List<Item>> groups = new ArrayList<List<Item>>(40);
    protected List<AtomicValue> groupKeys = new ArrayList<AtomicValue>(40);
    protected AtomicComparer comparer;

    public GroupByIterator(SequenceIterator population, Expression keyExpression, XPathContext keyContext, StringCollator collator) throws XPathException {
        this.population = population;
        this.keyExpression = keyExpression;
        this.keyContext = keyContext;
        this.collator = collator;
        int type = keyExpression.getItemType(keyContext.getConfiguration().getTypeHierarchy()).getPrimitiveType();
        this.comparer = AtomicSortComparer.makeSortComparer(collator, type, keyContext);
        this.buildIndexedGroups();
    }

    private void buildIndexedGroups() throws XPathException {
        Item item;
        HashMap<ComparisonKey, List<Item>> index = new HashMap<ComparisonKey, List<Item>>(40);
        XPathContextMinor c2 = this.keyContext.newMinorContext();
        c2.setCurrentIterator(this.population);
        c2.setOriginatingConstructType(2062);
        while ((item = this.population.next()) != null) {
            this.processItem(index, item, c2);
        }
    }

    protected void processItem(HashMap<ComparisonKey, List<Item>> index, Item item, XPathContext c2) throws XPathException {
        AtomicValue key;
        SequenceIterator keys = this.keyExpression.iterate(c2);
        boolean firstKey = true;
        while ((key = (AtomicValue)keys.next()) != null) {
            ComparisonKey comparisonKey = this.comparer.getComparisonKey(key);
            List<Item> g = index.get(comparisonKey);
            if (g == null) {
                ArrayList<Item> newGroup = new ArrayList<Item>(20);
                newGroup.add(item);
                this.groups.add(newGroup);
                this.groupKeys.add(key);
                index.put(comparisonKey, newGroup);
            } else if (firstKey) {
                g.add(item);
            } else if (g.get(g.size() - 1) != item) {
                g.add(item);
            }
            firstKey = false;
        }
    }

    @Override
    public AtomicValue getCurrentGroupingKey() {
        return this.groupKeys.get(this.position - 1);
    }

    @Override
    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.groups.get(this.position - 1));
    }

    public List getCurrentGroup() {
        return this.groups.get(this.position - 1);
    }

    @Override
    public boolean hasNext() {
        return this.position < this.groups.size();
    }

    @Override
    public Item next() throws XPathException {
        if (this.position >= 0 && this.position < this.groups.size()) {
            ++this.position;
            return this.current();
        }
        this.position = -1;
        return null;
    }

    @Override
    public Item current() {
        if (this.position < 1) {
            return null;
        }
        return (Item)((ArrayList)this.groups.get(this.position - 1)).get(0);
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        XPathContextMinor c2 = this.keyContext.newMinorContext();
        c2.setOriginatingConstructType(2062);
        return new GroupByIterator(this.population.getAnother(), this.keyExpression, c2, this.collator);
    }

    @Override
    public int getProperties() {
        return 6;
    }

    @Override
    public int getLastPosition() throws XPathException {
        return this.groups.size();
    }
}

