/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.Position;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public final class LocationPathPattern
extends Pattern {
    public Pattern parentPattern = null;
    public Pattern ancestorPattern = null;
    public NodeTest nodeTest = AnyNodeTest.getInstance();
    protected Expression[] filters = null;
    protected int numberOfFilters = 0;
    protected Expression equivalentExpr = null;
    protected boolean firstElementPattern = false;
    protected boolean lastElementPattern = false;
    protected boolean specialFilter = false;
    private Expression variableBinding = null;
    private NodeTest refinedNodeTest = null;

    public void addFilter(Expression filter) {
        if (this.filters == null) {
            this.filters = new Expression[1];
        } else if (this.numberOfFilters == this.filters.length) {
            Expression[] f2 = new Expression[this.numberOfFilters * 2];
            System.arraycopy(this.filters, 0, f2, 0, this.numberOfFilters);
            this.filters = f2;
        }
        this.filters[this.numberOfFilters++] = filter;
        filter.setContainer(this);
    }

    @Override
    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        if (this.parentPattern != null) {
            this.parentPattern.setLineNumber(lineNumber);
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern.setLineNumber(lineNumber);
        }
    }

    @Override
    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        if (this.parentPattern != null) {
            this.parentPattern.setSystemId(systemId);
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern.setSystemId(systemId);
        }
    }

    @Override
    public void setExecutable(Executable executable) {
        super.setExecutable(executable);
        if (this.parentPattern != null) {
            this.parentPattern.setExecutable(executable);
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern.setExecutable(executable);
        }
    }

    public Expression[] getFilters() {
        return this.filters;
    }

    public Pattern getParentPattern() {
        return this.parentPattern;
    }

    public Pattern getAncestorPattern() {
        return this.ancestorPattern;
    }

    @Override
    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.parentPattern == null && this.ancestorPattern == null && this.filters == null && !this.firstElementPattern && !this.lastElementPattern) {
            NodeTestPattern ntp = new NodeTestPattern(this.nodeTest);
            ntp.setSystemId(this.getSystemId());
            ntp.setLineNumber(this.getLineNumber());
            return ntp;
        }
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.simplify(visitor);
        } else if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.simplify(visitor);
        }
        if (this.filters != null) {
            int i = this.numberOfFilters - 1;
            while (i >= 0) {
                Expression filter = this.filters[i];
                this.filters[i] = filter = visitor.simplify(filter);
                --i;
            }
        }
        return this;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.analyze(visitor, contextItemType);
            AxisExpression step = this.nodeTest.getPrimitiveType() == 2 ? new AxisExpression(2, this.nodeTest) : new AxisExpression(3, this.nodeTest);
            step.setLocationId(env.getLocationMap().allocateLocationId(env.getSystemId(), this.getLineNumber()));
            step.setContainer(this);
            Expression exp = visitor.typeCheck(step, this.parentPattern.getNodeTest());
            this.refinedNodeTest = (NodeTest)exp.getItemType(th);
        } else if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.analyze(visitor, contextItemType);
        }
        if (this.filters != null) {
            Optimizer opt = visitor.getConfiguration().getOptimizer();
            int i = this.numberOfFilters - 1;
            while (i >= 0) {
                Expression filter = visitor.typeCheck(this.filters[i], this.getNodeTest());
                filter = ExpressionTool.unsortedIfHomogeneous(opt, filter);
                this.filters[i] = filter = visitor.optimize(filter, this.getNodeTest());
                if (Literal.isConstantBoolean(filter, true)) {
                    if (i == this.numberOfFilters - 1) {
                        --this.numberOfFilters;
                    } else {
                        System.arraycopy(this.filters, i + 1, this.filters, i, this.numberOfFilters - i - 1);
                        --this.numberOfFilters;
                    }
                    this.filters[this.numberOfFilters] = null;
                } else if (Literal.isConstantBoolean(filter, false)) {
                    return new NodeTestPattern(EmptySequenceTest.getInstance());
                }
                --i;
            }
        }
        if (this.nodeTest.getPrimitiveType() == 1 && this.numberOfFilters == 1) {
            ComparisonExpression comp;
            if (Literal.isConstantOne(this.filters[0])) {
                this.firstElementPattern = true;
                this.specialFilter = true;
                this.numberOfFilters = 0;
                this.filters = null;
            } else if (this.filters[0] instanceof ComparisonExpression && ((comp = (ComparisonExpression)((Object)this.filters[0])).getSingletonOperator() == 50 && comp.getOperands()[0] instanceof Position && Literal.isConstantOne(comp.getOperands()[1]) || comp.getOperands()[1] instanceof Position && Literal.isConstantOne(comp.getOperands()[0]))) {
                this.firstElementPattern = true;
                this.specialFilter = true;
                this.numberOfFilters = 0;
                this.filters = null;
            }
        }
        if (this.nodeTest.getPrimitiveType() == 1 && this.numberOfFilters == 1 && this.filters[0] instanceof IsLastExpression && ((IsLastExpression)this.filters[0]).getCondition()) {
            this.lastElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.isPositional(th)) {
            this.equivalentExpr = this.makePositionalExpression();
            this.equivalentExpr = visitor.typeCheck(this.equivalentExpr, contextItemType);
            this.specialFilter = true;
        }
        return this;
    }

    @Override
    public int getDependencies() {
        int dependencies = 0;
        if (this.parentPattern != null) {
            dependencies |= this.parentPattern.getDependencies();
        }
        if (this.ancestorPattern != null) {
            dependencies |= this.ancestorPattern.getDependencies();
        }
        int i = 0;
        while (i < this.numberOfFilters) {
            dependencies |= this.filters[i].getDependencies();
            ++i;
        }
        return dependencies &= 0x80;
    }

    @Override
    public Iterator iterateSubExpressions() {
        Iterator[] pair;
        Iterator iter = this.numberOfFilters == 0 ? Collections.EMPTY_LIST.iterator() : Arrays.asList(this.filters).subList(0, this.numberOfFilters).iterator();
        if (this.variableBinding != null) {
            pair = new Iterator[]{new MonoIterator(this.variableBinding), iter};
            iter = new MultiIterator(pair);
        }
        if (this.parentPattern != null) {
            pair = new Iterator[]{iter, this.parentPattern.iterateSubExpressions()};
            iter = new MultiIterator(pair);
        }
        if (this.ancestorPattern != null) {
            pair = new Iterator[]{iter, this.ancestorPattern.iterateSubExpressions()};
            iter = new MultiIterator(pair);
        }
        return iter;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        int i = 0;
        while (i < this.numberOfFilters) {
            if (this.filters[i] == original) {
                this.filters[i] = replacement;
                found = true;
            }
            ++i;
        }
        if (this.parentPattern != null) {
            found |= this.parentPattern.replaceSubExpression(original, replacement);
        }
        if (this.ancestorPattern != null) {
            found |= this.ancestorPattern.replaceSubExpression(original, replacement);
        }
        if (this.variableBinding == original) {
            this.variableBinding = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int allocateSlots(StaticContext env, SlotManager slotManager, int nextFree) {
        if (this.variableBinding != null) {
            nextFree = ExpressionTool.allocateSlots(this.variableBinding, nextFree, slotManager);
        }
        int i = 0;
        while (i < this.numberOfFilters) {
            nextFree = ExpressionTool.allocateSlots(this.filters[i], nextFree, slotManager);
            ++i;
        }
        if (this.parentPattern != null) {
            nextFree = this.parentPattern.allocateSlots(env, slotManager, nextFree);
        }
        if (this.ancestorPattern != null) {
            nextFree = this.ancestorPattern.allocateSlots(env, slotManager, nextFree);
        }
        return nextFree;
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        if (this.parentPattern != null) {
            this.parentPattern.promote(offer, parent);
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern.promote(offer, parent);
        }
        Binding[] savedBindingList = offer.bindingList;
        if (this.variableBinding instanceof Assignation) {
            offer.bindingList = ((Assignation)this.variableBinding).extendBindingList(offer.bindingList);
        }
        int i = 0;
        while (i < this.numberOfFilters) {
            this.filters[i] = this.filters[i].promote(offer, parent);
            ++i;
        }
        offer.bindingList = savedBindingList;
    }

    private Expression makePositionalExpression() {
        byte axis = this.nodeTest.getPrimitiveType() == 2 ? (byte)2 : 3;
        Expression step = new AxisExpression(axis, this.nodeTest);
        int n = 0;
        while (n < this.numberOfFilters) {
            step = new FilterExpression(step, this.filters[n]);
            ++n;
        }
        ParentNodeExpression start = new ParentNodeExpression();
        start.setContainer(this);
        PathExpression path = new PathExpression(start, step);
        path.setContainer(this);
        return path;
    }

    @Override
    public boolean matches(NodeInfo node, XPathContext context) throws XPathException {
        if (this.variableBinding != null) {
            XPathContext c2 = context;
            Item ci = context.getContextItem();
            if (!(ci instanceof NodeInfo) || !((NodeInfo)ci).isSameNodeInfo(node)) {
                c2 = context.newContext();
                UnfailingIterator si = SingletonIterator.makeIterator(node);
                si.next();
                c2.setCurrentIterator(si);
            }
            this.variableBinding.evaluateItem(c2);
        }
        return this.internalMatches(node, context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean internalMatches(NodeInfo node, XPathContext context) throws XPathException {
        XPathContextMinor c2;
        if (!this.nodeTest.matches(node)) {
            return false;
        }
        if (this.parentPattern != null) {
            NodeInfo par = node.getParent();
            if (par == null) {
                return false;
            }
            if (!this.parentPattern.internalMatches(par, context)) {
                return false;
            }
        }
        if (this.ancestorPattern != null) {
            NodeInfo anc = node.getParent();
            while (true) {
                if (anc == null) {
                    return false;
                }
                if (this.ancestorPattern.internalMatches(anc, context)) break;
                anc = anc.getParent();
            }
        }
        if (this.specialFilter) {
            AxisIterator iter;
            if (this.firstElementPattern) {
                iter = node.iterateAxis((byte)11, this.nodeTest);
                return iter.next() == null;
            }
            if (this.lastElementPattern) {
                iter = node.iterateAxis((byte)7, this.nodeTest);
                return iter.next() == null;
            }
            if (this.equivalentExpr != null) {
                c2 = context.newMinorContext();
                c2.setOriginatingConstructType(2064);
                UnfailingIterator single = SingletonIterator.makeIterator(node);
                single.next();
                c2.setCurrentIterator(single);
                try {
                    NodeInfo n;
                    SequenceIterator nsv = this.equivalentExpr.iterate(c2);
                    do {
                        if ((n = (NodeInfo)nsv.next()) != null) continue;
                        return false;
                    } while (!n.isSameNodeInfo(node));
                    return true;
                }
                catch (XPathException e) {
                    XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", e);
                    err.setXPathContext(c2);
                    err.setErrorCodeQName(e.getErrorCodeQName());
                    err.setLocator(this);
                    c2.getController().recoverableError(err);
                    return false;
                }
            }
        }
        if (this.filters != null) {
            c2 = context.newMinorContext();
            c2.setOriginatingConstructType(2064);
            UnfailingIterator iter = SingletonIterator.makeIterator(node);
            iter.next();
            c2.setCurrentIterator(iter);
            int i = 0;
            while (i < this.numberOfFilters) {
                try {
                    if (!this.filters[i].effectiveBooleanValue(c2)) {
                        return false;
                    }
                }
                catch (XPathException e) {
                    if ("XTDE0640".equals(e.getErrorCodeLocalPart())) {
                        throw e;
                    }
                    XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", e);
                    err.setXPathContext(c2);
                    err.setErrorCodeQName(e.getErrorCodeQName());
                    err.setLocator(this);
                    c2.getController().recoverableError(err);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public int getNodeKind() {
        return this.nodeTest.getPrimitiveType();
    }

    @Override
    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    @Override
    public NodeTest getNodeTest() {
        if (this.refinedNodeTest != null) {
            return this.refinedNodeTest;
        }
        return this.nodeTest;
    }

    private boolean isPositional(TypeHierarchy th) {
        if (this.filters == null) {
            return false;
        }
        int i = 0;
        while (i < this.numberOfFilters) {
            int type = this.filters[i].getItemType(th).getPrimitiveType();
            if (type == 517 || type == 515 || type == 532 || type == 516 || type == 632) {
                return true;
            }
            if ((this.filters[i].getDependencies() & 0xC) != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void resolveCurrent(LetExpression let, PromotionOffer offer, boolean topLevel) throws XPathException {
        int i = 0;
        while (i < this.numberOfFilters) {
            this.filters[i] = this.filters[i].promote(offer, let);
            ++i;
        }
        if (this.parentPattern instanceof LocationPathPattern) {
            ((LocationPathPattern)this.parentPattern).resolveCurrent(let, offer, false);
        }
        if (this.ancestorPattern instanceof LocationPathPattern) {
            ((LocationPathPattern)this.ancestorPattern).resolveCurrent(let, offer, false);
        }
        if (topLevel) {
            this.variableBinding = let;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof LocationPathPattern) {
            LocationPathPattern lpp = (LocationPathPattern)other;
            if (this.numberOfFilters != lpp.numberOfFilters) {
                return false;
            }
            int i = 0;
            while (i < this.numberOfFilters) {
                if (!this.filters[i].equals(lpp.filters[i])) {
                    return false;
                }
                ++i;
            }
            if (!this.nodeTest.equals(lpp.nodeTest)) {
                return false;
            }
            if (this.parentPattern == null ? lpp.parentPattern != null : !this.parentPattern.equals(lpp.parentPattern)) {
                return false;
            }
            return !(this.ancestorPattern == null ? lpp.ancestorPattern != null : !this.ancestorPattern.equals(lpp.ancestorPattern));
        }
        return false;
    }

    public int hashCode() {
        int h = 88267;
        int i = 0;
        while (i < this.numberOfFilters) {
            h ^= this.filters[i].hashCode();
            ++i;
        }
        h ^= this.nodeTest.hashCode();
        if (this.parentPattern != null) {
            h ^= this.parentPattern.hashCode();
        }
        if (this.ancestorPattern != null) {
            h ^= this.ancestorPattern.hashCode();
        }
        return h;
    }
}

