/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.local;

import net.sf.saxon.number.AbstractNumberer;

public class Numberer_sv
extends AbstractNumberer {
    private static final long serialVersionUID = 1L;
    private static String[] swedishOrdinalUnits = new String[]{"", "f\ufffdrsta", "andra", "tredje", "fj\ufffdrde", "femte", "sj\ufffdtte", "sjunde", "\ufffdttonde", "nionde", "tionde", "elfte", "tolfte", "trettonde", "fjortonde", "femtonde", "sextonde", "sjuttonde", "artonde", "n\ufffdttonde"};
    private static String[] swedishOrdinalTens = new String[]{"", "tionde", "tjugonde", "trettionde", "fyrtionde", "femtionde", "sextionde", "sjuttionde", "\ufffdttionde", "n\ufffdttionde"};
    private static String[] swedishUnits = new String[]{"", "ett", "tv\ufffd", "tre", "fyra", "fem", "sex", "sju", "\ufffdtta", "nio", "tio", "elva", "tolv", "tretton", "fjorton", "femton", "sexton", "sjutton", "arton", "nitton"};
    private static String[] swedishTens = new String[]{"", "tio", "tjugo", "trettio", "fyrtio", "femtio", "sextio", "sjuttio", "\ufffdttio", "nittio"};
    private static String[] swedishMonths = new String[]{"januari", "februari", "mars", "april", "maj", "juni", "juli", "augusti", "september", "oktober", "november", "december"};
    private static String[] swedishDays = new String[]{"m\ufffdndag", "tisdag", "onsdag", "torsdag", "fredag", "l\ufffdrdag", "s\ufffdndag"};
    private static String[] swedishDayAbbreviations = new String[]{"m\ufffd", "ti", "on", "to", "fr", "l\ufffd", "s\ufffd"};
    private static int[] minUniqueDayLength = new int[]{1, 2, 1, 2, 1, 2, 2};

    @Override
    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        String s;
        if (number == 1000000000L) {
            s = "miljardte";
        } else if (number == 1000000L) {
            s = "miljonte";
        } else if (number == 1000L) {
            s = "tusende";
        } else if (number == 100L) {
            s = "hundrade";
        } else if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            s = String.valueOf(number / 1000000000L == 1L ? "en" : this.toWords(number / 1000000000L)) + " miljard " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 1000000L) {
            long rem = number % 1000000L;
            s = String.valueOf(number / 1000000L == 1L ? "en" : this.toWords(number / 1000000L)) + " miljon " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 1000L) {
            long rem = number % 1000L;
            s = String.valueOf(number / 1000L == 1L ? "et" : this.toWords(number / 1000L)) + "tusen" + " " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 100L) {
            long rem = number % 100L;
            s = String.valueOf(number / 100L == 1L ? "" : this.toWords(number / 100L)) + "hundra" + (rem == 0L || rem > 19L ? "" : "en") + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else {
            int rem;
            s = number < 20L ? swedishOrdinalUnits[(int)number] : ((rem = (int)(number % 10L)) == 0 ? swedishOrdinalTens[(int)number / 10] : String.valueOf(swedishTens[(int)number / 10]) + swedishOrdinalUnits[rem]);
        }
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    @Override
    public String toWords(long number) {
        if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            return String.valueOf(number / 1000000000L == 1L ? "en " : this.toWords(number / 1000000000L)) + "miljard" + (rem == 0L ? "" : " ") + this.toWords(rem);
        }
        if (number >= 1000000L) {
            long rem = number % 1000000L;
            return String.valueOf(number / 1000000L == 1L ? "en " : this.toWords(number / 1000000L)) + "miljon" + (rem == 0L ? "" : " ") + this.toWords(rem);
        }
        if (number >= 1000L) {
            long rem = number % 1000L;
            return String.valueOf(number / 1000L == 1L ? "et" : this.toWords(number / 1000L)) + "tusen" + (rem == 0L ? "" : String.valueOf(rem < 100L ? "en" : " ") + this.toWords(rem));
        }
        if (number >= 100L) {
            long rem = number % 100L;
            return String.valueOf(number / 100L == 1L ? "" : this.toWords(number / 100L)) + "hundra" + this.toWords(rem);
        }
        if (number < 20L) {
            return swedishUnits[(int)number];
        }
        int rem = (int)(number % 10L);
        return String.valueOf(swedishTens[(int)number / 10]) + swedishUnits[rem];
    }

    @Override
    public String toWords(long number, int wordCase) {
        String s = number == 0L ? "noll" : this.toWords(number);
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    @Override
    public String monthName(int month, int minWidth, int maxWidth) {
        String name = swedishMonths[month - 1];
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        if (name.length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = String.valueOf(name) + ' ';
        }
        return name;
    }

    @Override
    public String dayName(int day, int minWidth, int maxWidth) {
        String name = swedishDays[day - 1];
        if (maxWidth < 2) {
            maxWidth = 2;
        }
        if (name.length() > maxWidth && (name = swedishDayAbbreviations[day - 1]).length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = String.valueOf(name) + ' ';
        }
        if (minWidth == 1 && maxWidth == 2) {
            name = name.substring(0, minUniqueDayLength[day - 1]);
        }
        return name;
    }
}

