/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public final class ValueOf
extends SimpleNodeConstructor {
    private int options;
    private boolean isNumberingInstruction = false;
    private boolean noNodeIfEmpty;

    public ValueOf(Expression select, boolean disable, boolean noNodeIfEmpty) {
        this.select = select;
        this.options = disable ? 1 : 0;
        this.noNodeIfEmpty = noNodeIfEmpty;
        this.adoptChildExpression(select);
        if (select instanceof StringLiteral) {
            boolean special = false;
            String val = ((StringLiteral)select).getStringValue();
            int k = 0;
            while (k < val.length()) {
                char c = val.charAt(k);
                if (c < '!' || c > '~' || c == '<' || c == '>' || c == '&') {
                    special = true;
                    break;
                }
                ++k;
            }
            if (!special) {
                this.options |= 4;
            }
        }
    }

    public void setIsNumberingInstruction() {
        this.isNumberingInstruction = true;
    }

    public boolean isNumberingInstruction() {
        return this.isNumberingInstruction;
    }

    @Override
    public int getInstructionNameCode() {
        if (this.isNumberingInstruction) {
            return 160;
        }
        if (this.select instanceof StringLiteral) {
            return 182;
        }
        return 184;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        super.promoteInst(offer);
    }

    public int getOptions() {
        return this.options;
    }

    public boolean isDisableOutputEscaping() {
        return (this.options & 1) != 0;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.TEXT;
    }

    @Override
    public int computeCardinality() {
        if (this.noNodeIfEmpty) {
            return 24576;
        }
        return 16384;
    }

    @Override
    public void localTypeCheck(ExpressionVisitor visitor, ItemType contextItemType) {
    }

    @Override
    public Expression copy() {
        ValueOf exp = new ValueOf(this.select.copy(), (this.options & 1) != 0, this.noNodeIfEmpty);
        if (this.isNumberingInstruction) {
            exp.setIsNumberingInstruction();
        }
        return exp;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (this.select instanceof Literal) {
            Value selectValue = ((Literal)this.select).getValue();
            SimpleType stype = null;
            if (parentType instanceof SimpleType && whole) {
                stype = (SimpleType)parentType;
            } else if (parentType instanceof ComplexType && ((ComplexType)parentType).isSimpleContent()) {
                stype = ((ComplexType)parentType).getSimpleContentType();
            }
            if (whole && stype != null && !stype.isNamespaceSensitive()) {
                ValidationFailure err = stype.validateContent(selectValue.getStringValue(), null, env.getConfiguration().getNameChecker());
                if (err != null) {
                    err.setLocator(this);
                    throw err.makeException();
                }
                return;
            }
            if (parentType instanceof ComplexType && !((ComplexType)parentType).isSimpleContent() && !((ComplexType)parentType).isMixedContent() && !Whitespace.isWhite(selectValue.getStringValue())) {
                XPathException err = new XPathException("Complex type " + parentType.getDescription() + " does not allow text content " + Err.wrap(selectValue.getStringValue()));
                err.setLocator(this);
                err.setIsTypeError(true);
                throw err;
            }
        }
    }

    public Expression convertToStringJoin(StaticContext env) {
        if (this.select.getItemType(env.getConfiguration().getTypeHierarchy()).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return this.select;
        }
        if (this.select instanceof StringLiteral) {
            try {
                return new Literal(new UntypedAtomicValue(((StringLiteral)this.select).getValue().getStringValueCS()));
            }
            catch (XPathException err) {
                throw new AssertionError((Object)err);
            }
        }
        StringFn fn = (StringFn)SystemFunction.makeSystemFunction("string", new Expression[]{this.select});
        return new CastExpression(fn, BuiltInAtomicType.UNTYPED_ATOMIC, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        Item item = this.select.evaluateItem(context);
        if (item != null) {
            out.characters(item.getStringValueCS(), this.locationId, this.options);
        }
        return null;
    }

    @Override
    protected void processValue(CharSequence value, XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        out.characters(value, this.locationId, this.options);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        try {
            CharSequence val;
            Item item = this.select.evaluateItem(context);
            if (item == null) {
                if (this.noNodeIfEmpty) {
                    return null;
                }
                val = "";
            } else {
                val = item.getStringValueCS();
            }
            Orphan o = new Orphan(context.getController().getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(val);
            return o;
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("valueOf");
        this.getSelect().explain(out);
        out.endElement();
    }
}

