/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.TraceWrapper;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;

public class TraceExpression
extends TraceWrapper
implements InstructionInfo {
    private int lineNumber = -1;
    private int columnNumber = -1;
    private String systemId = null;
    private StructuredQName objectName;
    private int constructType;
    private NamespaceResolver namespaceResolver = null;
    private HashMap<String, Object> properties = new HashMap(10);

    public TraceExpression(Expression child) {
        this.child = child;
        this.adoptChildExpression(child);
        this.setProperty("expression", child);
    }

    public void setLineNumber(int line) {
        this.lineNumber = line;
    }

    public void setColumnNumber(int column) {
        this.columnNumber = column;
    }

    public void setConstructType(int type) {
        this.constructType = type;
    }

    @Override
    public int getConstructType() {
        return this.constructType;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setObjectName(StructuredQName qName) {
        this.objectName = qName;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.objectName;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Iterator getProperties() {
        return this.properties.keySet().iterator();
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public InstructionInfo getInstructionInfo() {
        return this;
    }

    @Override
    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    @Override
    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    @Override
    public int getColumnNumber(long locationId) {
        return this.getColumnNumber();
    }
}

