/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.evpull.BlockEventIterator;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.BlockIterator;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class Block
extends Instruction {
    private Expression[] children;

    public static Expression makeBlock(Expression e1, Expression e2) {
        if (e1 == null || Literal.isEmptySequence(e1)) {
            return e2;
        }
        if (e2 == null || Literal.isEmptySequence(e2)) {
            return e1;
        }
        if (e1 instanceof Block || e2 instanceof Block) {
            MonoIterator it1 = e1 instanceof Block ? e1.iterateSubExpressions() : new MonoIterator(e1);
            MonoIterator it2 = e2 instanceof Block ? e2.iterateSubExpressions() : new MonoIterator(e2);
            ArrayList list = new ArrayList(10);
            while (it1.hasNext()) {
                list.add(it1.next());
            }
            while (it2.hasNext()) {
                list.add(it2.next());
            }
            Expression[] exps = new Expression[list.size()];
            exps = list.toArray(exps);
            Block b = new Block();
            b.setChildren(exps);
            return b;
        }
        Expression[] exps = new Expression[]{e1, e2};
        Block b = new Block();
        b.setChildren(exps);
        return b;
    }

    public static Expression makeBlock(List<Expression> list) {
        if (list.size() == 0) {
            return Literal.makeEmptySequence();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        Expression[] exps = new Expression[list.size()];
        exps = list.toArray(exps);
        Block b = new Block();
        b.setChildren(exps);
        return b;
    }

    public void setChildren(Expression[] children) {
        if (children == null || children.length == 0) {
            this.children = null;
        } else {
            this.children = children;
            int c = 0;
            while (c < children.length) {
                this.adoptChildExpression(children[c]);
                ++c;
            }
        }
    }

    public Expression[] getChildren() {
        return this.children;
    }

    @Override
    public int computeSpecialProperties() {
        if (this.children == null || this.children.length == 0) {
            return 0x2FF0000;
        }
        int p = super.computeSpecialProperties();
        boolean allAxisExpressions = true;
        boolean allChildAxis = true;
        boolean allSubtreeAxis = true;
        int i = 0;
        while (i < this.children.length) {
            if (!(this.children[i] instanceof AxisExpression)) {
                allAxisExpressions = false;
                allChildAxis = false;
                allSubtreeAxis = false;
                break;
            }
            byte axis = ((AxisExpression)this.children[i]).getAxis();
            if (axis != 3) {
                allChildAxis = false;
            }
            if (!Axis.isSubtreeAxis[axis]) {
                allSubtreeAxis = false;
            }
            ++i;
        }
        if (allAxisExpressions) {
            p |= 0xC10000;
            if (allChildAxis) {
                p |= 0x80000;
            }
            if (allSubtreeAxis) {
                p |= 0x100000;
            }
            if (this.children.length == 2 && ((AxisExpression)this.children[0]).getAxis() == 2 && ((AxisExpression)this.children[1]).getAxis() == 3) {
                p |= 0x20000;
            }
        }
        return p;
    }

    public Expression mergeAdjacentTextInstructions() {
        boolean[] isLiteralText = new boolean[this.children.length];
        boolean hasAdjacentTextNodes = false;
        int i = 0;
        while (i < this.children.length) {
            boolean bl = isLiteralText[i] = this.children[i] instanceof ValueOf && ((ValueOf)this.children[i]).getSelect() instanceof StringLiteral && !((ValueOf)this.children[i]).isDisableOutputEscaping();
            if (i > 0 && isLiteralText[i] && isLiteralText[i - 1]) {
                hasAdjacentTextNodes = true;
            }
            ++i;
        }
        if (hasAdjacentTextNodes) {
            ArrayList<Expression> content = new ArrayList<Expression>(this.children.length);
            String pendingText = null;
            int i2 = 0;
            while (i2 < this.children.length) {
                if (isLiteralText[i2]) {
                    pendingText = String.valueOf(pendingText == null ? "" : pendingText) + ((StringLiteral)((ValueOf)this.children[i2]).getSelect()).getStringValue();
                } else {
                    if (pendingText != null) {
                        ValueOf inst = new ValueOf(new StringLiteral(pendingText), false, false);
                        content.add(inst);
                        pendingText = null;
                    }
                    content.add(this.children[i2]);
                }
                ++i2;
            }
            if (pendingText != null) {
                ValueOf inst = new ValueOf(new StringLiteral(pendingText), false, false);
                content.add(inst);
            }
            return Block.makeBlock(content);
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        if (this.children == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Arrays.asList(this.children).iterator();
    }

    public boolean containsLocalParam() {
        return this.children != null && this.children.length > 0 && this.children[0] instanceof LocalParam;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        int c = 0;
        while (c < this.children.length) {
            if (this.children[c] == original) {
                this.children[c] = replacement;
                found = true;
            }
            ++c;
        }
        return found;
    }

    @Override
    public Expression copy() {
        Expression[] c2 = new Expression[this.children.length];
        int c = 0;
        while (c < this.children.length) {
            c2[c] = this.children[c].copy();
            ++c;
        }
        Block b2 = new Block();
        b2.children = c2;
        return b2;
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        if (this.children == null || this.children.length == 0) {
            return EmptySequenceTest.getInstance();
        }
        ItemType t1 = this.children[0].getItemType(th);
        int i = 1;
        while (i < this.children.length) {
            if ((t1 = Type.getCommonSuperType(t1, this.children[i].getItemType(th), th)) instanceof AnyItemType) {
                return t1;
            }
            ++i;
        }
        return t1;
    }

    @Override
    public final int getCardinality() {
        if (this.children == null || this.children.length == 0) {
            return 8192;
        }
        int c1 = this.children[0].getCardinality();
        int i = 1;
        while (i < this.children.length) {
            if ((c1 = Cardinality.sum(c1, this.children[i].getCardinality())) == 57344) break;
            ++i;
        }
        return c1;
    }

    @Override
    public final boolean createsNewNodes() {
        if (this.children == null) {
            return false;
        }
        int i = 0;
        while (i < this.children.length) {
            int props = this.children[i].getSpecialProperties();
            if ((props & 0x400000) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        if (this.children == null || this.children.length < 2) {
            return;
        }
        boolean updating = false;
        boolean nonUpdating = false;
        int i = 0;
        while (i < this.children.length) {
            Expression act = this.children[i];
            if (!ExpressionTool.isAllowedInUpdatingContext(act)) {
                if (updating) {
                    XPathException err = new XPathException("If any subexpression is updating, then all must be updating", "XUST0001");
                    err.setLocator(this.children[i]);
                    throw err;
                }
                nonUpdating = true;
            }
            if (act.isUpdatingExpression()) {
                if (nonUpdating) {
                    XPathException err = new XPathException("If any subexpression is updating, then all must be updating", "XUST0001");
                    err.setLocator(this.children[i]);
                    throw err;
                }
                updating = true;
            }
            ++i;
        }
    }

    @Override
    public boolean isUpdatingExpression() {
        if (this.children == null || this.children.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].isUpdatingExpression()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isVacuousExpression() {
        if (this.children == null || this.children.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.children.length) {
            if (!this.children[0].isVacuousExpression()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        boolean allAtomic = true;
        boolean nested = false;
        if (this.children != null) {
            int c = 0;
            while (c < this.children.length) {
                this.children[c] = visitor.simplify(this.children[c]);
                if (!Literal.isAtomic(this.children[c])) {
                    allAtomic = false;
                }
                if (this.children[c] instanceof Block) {
                    nested = true;
                } else if (Literal.isEmptySequence(this.children[c])) {
                    nested = true;
                }
                ++c;
            }
            if (this.children.length == 1) {
                return this.getChildren()[0];
            }
            if (this.children.length == 0) {
                Literal result = Literal.makeEmptySequence();
                ExpressionTool.copyLocationInfo(this, result);
                return result;
            }
            if (nested) {
                ArrayList<Expression> list = new ArrayList<Expression>(this.children.length * 2);
                this.flatten(list);
                this.children = new Expression[list.size()];
                int i = 0;
                while (i < this.children.length) {
                    this.children[i] = (Expression)list.get(i);
                    this.adoptChildExpression(this.children[i]);
                    ++i;
                }
            }
            if (allAtomic) {
                Item[] values = new AtomicValue[this.children.length];
                int c2 = 0;
                while (c2 < this.children.length) {
                    values[c2] = (AtomicValue)((Literal)this.children[c2]).getValue();
                    ++c2;
                }
                Literal result = Literal.makeLiteral(new SequenceExtent(values));
                ExpressionTool.copyLocationInfo(this, result);
                return result;
            }
        } else {
            Literal result = Literal.makeEmptySequence();
            ExpressionTool.copyLocationInfo(this, result);
            return result;
        }
        return this;
    }

    private void flatten(List<Expression> targetList) throws XPathException {
        ArrayList<Item> currentLiteralList = null;
        int i = 0;
        while (i < this.children.length) {
            if (!Literal.isEmptySequence(this.children[i])) {
                if (this.children[i] instanceof Block) {
                    this.flushCurrentLiteralList(currentLiteralList, targetList);
                    currentLiteralList = null;
                    ((Block)this.children[i]).flatten(targetList);
                } else if (this.children[i] instanceof Literal && !(((Literal)this.children[i]).getValue() instanceof IntegerRange)) {
                    Item item;
                    SequenceIterator iterator = ((Literal)this.children[i]).getValue().iterate();
                    if (currentLiteralList == null) {
                        currentLiteralList = new ArrayList<Item>(10);
                    }
                    while ((item = iterator.next()) != null) {
                        currentLiteralList.add(item);
                    }
                } else {
                    this.flushCurrentLiteralList(currentLiteralList, targetList);
                    currentLiteralList = null;
                    targetList.add(this.children[i]);
                }
            }
            ++i;
        }
        this.flushCurrentLiteralList(currentLiteralList, targetList);
    }

    private void flushCurrentLiteralList(List<Item> currentLiteralList, List<Expression> list) throws XPathException {
        if (currentLiteralList != null) {
            ListIterator iter = new ListIterator(currentLiteralList);
            list.add(Literal.makeLiteral((Value)SequenceExtent.makeSequenceExtent(iter)));
        }
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.children == null) {
            return new Literal(EmptySequence.getInstance());
        }
        int c = 0;
        while (c < this.children.length) {
            this.children[c] = visitor.typeCheck(this.children[c], contextItemType);
            this.adoptChildExpression(this.children[c]);
            ++c;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int c = 0;
        while (c < this.children.length) {
            this.children[c] = visitor.optimize(this.children[c], contextItemType);
            this.adoptChildExpression(this.children[c]);
            ++c;
        }
        boolean canSimplify = false;
        boolean prevLiteral = false;
        int c2 = 0;
        while (c2 < this.children.length) {
            if (this.children[c2] instanceof Block) {
                canSimplify = true;
                break;
            }
            if (this.children[c2] instanceof Literal) {
                if (prevLiteral || Literal.isEmptySequence(this.children[c2])) {
                    canSimplify = true;
                    break;
                }
                prevLiteral = true;
            } else {
                prevLiteral = false;
            }
            ++c2;
        }
        if (canSimplify) {
            ArrayList<Expression> list = new ArrayList<Expression>(this.children.length * 2);
            this.flatten(list);
            this.children = new Expression[list.size()];
            int i = 0;
            while (i < this.children.length) {
                this.children[i] = (Expression)list.get(i);
                this.adoptChildExpression(this.children[i]);
                ++i;
            }
        }
        if (this.children == null || this.children.length == 0) {
            return Literal.makeEmptySequence();
        }
        if (this.children.length == 1) {
            return this.children[0];
        }
        return this;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.children != null) {
            int c = 0;
            while (c < this.children.length) {
                this.children[c] = this.doPromotion(this, this.children[c], offer);
                ++c;
            }
        }
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (this.children != null) {
            int c = 0;
            while (c < this.children.length) {
                this.children[c].checkPermittedContents(parentType, env, false);
                ++c;
            }
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("sequence");
        if (this.children != null) {
            int c = 0;
            while (c < this.children.length) {
                this.children[c].explain(out);
                ++c;
            }
        }
        out.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (this.children == null) {
            return null;
        }
        TailCall tc = null;
        int i = 0;
        while (i < this.children.length) {
            try {
                if (this.children[i] instanceof TailCallReturner) {
                    tc = ((TailCallReturner)((Object)this.children[i])).processLeavingTail(context);
                } else {
                    this.children[i].process(context);
                    tc = null;
                }
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.children[i]);
                e.maybeSetContext(context);
                throw e;
            }
            ++i;
        }
        return tc;
    }

    public void processLocalParams(XPathContext context) throws XPathException {
        if (this.children == null) {
            return;
        }
        int i = 0;
        while (i < this.children.length) {
            block5: {
                try {
                    if (this.children[i] instanceof LocalParam) {
                        this.children[i].process(context);
                        break block5;
                    }
                    return;
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this.children[i]);
                    e.maybeSetContext(context);
                    throw e;
                }
            }
            ++i;
        }
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        if (this.children == null || this.children.length == 0) {
            return EmptyIterator.getInstance();
        }
        if (this.children.length == 1) {
            return this.children[0].iterate(context);
        }
        return new BlockIterator(this.children, context);
    }

    @Override
    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        if (this.children == null || this.children.length == 0) {
            return EmptyEventIterator.getInstance();
        }
        if (this.children.length == 1) {
            return this.children[0].iterateEvents(context);
        }
        return new BlockEventIterator(this.children, context);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        if (this.children == null) {
            return;
        }
        int i = 0;
        while (i < this.children.length) {
            this.children[i].evaluatePendingUpdates(context, pul);
            ++i;
        }
    }
}

