/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ExtensionFunctionCall;
import net.sf.saxon.functions.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class IntegratedFunctionCall
extends FunctionCall {
    private ExtensionFunctionCall function;
    private SequenceType resultType = SequenceType.ANY_SEQUENCE;
    private int state = 0;

    public IntegratedFunctionCall(ExtensionFunctionCall function) {
        this.function = function;
    }

    public ExtensionFunctionCall getFunction() {
        return this.function;
    }

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        this.checkArgumentCount(definition.getMinimumNumberOfArguments(), definition.getMaximumNumberOfArguments(), visitor);
        int args = this.getNumberOfArguments();
        SequenceType[] declaredArgumentTypes = definition.getArgumentTypes();
        if (declaredArgumentTypes == null || args != 0 && declaredArgumentTypes.length == 0) {
            throw new XPathException("Integrated function " + this.getDisplayName() + " failed to declare its argument types");
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        SequenceType[] actualArgumentTypes = new SequenceType[args];
        int i = 0;
        while (i < args) {
            this.argument[i] = TypeChecker.staticTypeCheck(this.argument[i], i < declaredArgumentTypes.length ? declaredArgumentTypes[i] : declaredArgumentTypes[declaredArgumentTypes.length - 1], false, new RoleLocator(0, this.getFunctionName(), i), visitor);
            actualArgumentTypes[i] = SequenceType.makeSequenceType(this.argument[i].getItemType(th), this.argument[i].getCardinality());
            ++i;
        }
        this.resultType = definition.getResultType(actualArgumentTypes);
        if (this.state == 0) {
            this.function.supplyStaticContext(visitor.getStaticContext(), 0, this.getArguments());
        }
        ++this.state;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = super.typeCheck(visitor, contextItemType);
        if (exp instanceof IntegratedFunctionCall) {
            Expression exp2 = ((IntegratedFunctionCall)exp).function.rewrite(visitor.getStaticContext(), this.argument);
            if (exp2 == null) {
                return exp;
            }
            ExpressionTool.copyLocationInfo(this, exp2);
            return exp2.simplify(visitor).typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
        }
        return exp;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.resultType.getPrimaryType();
    }

    @Override
    protected int computeCardinality() {
        return this.resultType.getCardinality();
    }

    @Override
    public int getIntrinsicDependencies() {
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        return definition.dependsOnFocus() ? 30 : 0;
    }

    @Override
    protected int computeSpecialProperties() {
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        return definition.hasSideEffects() ? 0x1000000 : 0x400000;
    }

    @Override
    public Expression copy() {
        ExtensionFunctionCall newCall = this.function.getDefinition().makeCallExpression();
        newCall.setDefinition(this.function.getDefinition());
        this.function.copyLocalData(newCall);
        IntegratedFunctionCall copy = new IntegratedFunctionCall(newCall);
        Expression[] args = new Expression[this.getNumberOfArguments()];
        int i = 0;
        while (i < args.length) {
            args[i] = this.argument[i].copy();
            ++i;
        }
        copy.setFunctionName(this.getFunctionName());
        copy.setArguments(args);
        copy.resultType = this.resultType;
        copy.state = this.state;
        return copy;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator result;
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        SequenceIterator[] argValues = new SequenceIterator[this.getNumberOfArguments()];
        int i = 0;
        while (i < argValues.length) {
            argValues[i] = this.argument[i].iterate(context);
            ++i;
        }
        RoleLocator role = new RoleLocator(0, (Serializable)((Object)"result"), 0);
        final Configuration config = context.getConfiguration();
        try {
            result = this.function.call(argValues, context);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            throw e;
        }
        if (!definition.trustResultType()) {
            ItemType type;
            int card = this.resultType.getCardinality();
            if (card != 57344) {
                result = new CardinalityCheckingIterator(result, card, role, this);
            }
            if ((type = this.resultType.getPrimaryType()) != AnyItemType.getInstance()) {
                result = new ItemMappingIterator(result, new ItemMappingFunction(){

                    @Override
                    public Item map(Item item) throws XPathException {
                        if (!type.matchesItem(item, false, config)) {
                            String msg = "Item returned by integrated function " + IntegratedFunctionCall.this.getFunctionName().getDisplayName() + "() is not of declared item type. Actual type is " + Value.asValue(item).getItemType(config.getTypeHierarchy()).toString(config.getNamePool()) + "; expected type is " + type.toString(config.getNamePool());
                            XPathException err = new XPathException(msg);
                            err.setErrorCode("XPTY0004");
                            err.setLocator(IntegratedFunctionCall.this);
                            throw err;
                        }
                        return item;
                    }
                }, true);
            }
        }
        return result;
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        SequenceIterator[] argValues = new SequenceIterator[this.getNumberOfArguments()];
        int i = 0;
        while (i < argValues.length) {
            argValues[i] = this.argument[i].iterate(context);
            ++i;
        }
        try {
            return this.function.effectiveBooleanValue(argValues, context);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            throw e;
        }
    }
}

