/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class Concat
extends SystemFunction {
    @Override
    protected SequenceType getRequiredType(int arg) {
        return this.getDetails().argumentTypes[0];
    }

    @Override
    public CharSequence evaluateAsString(XPathContext c) throws XPathException {
        return this.evaluateItem(c).getStringValueCS();
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        int numArgs = this.argument.length;
        FastStringBuffer sb = new FastStringBuffer(64);
        int i = 0;
        while (i < numArgs) {
            AtomicValue val = (AtomicValue)this.argument[i].evaluateItem(c);
            if (val != null) {
                sb.append(val.getStringValueCS());
            }
            ++i;
        }
        return StringValue.makeStringValue(sb.condense());
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        if (out instanceof ComplexContentOutputter) {
            int numArgs = this.argument.length;
            out.append(StringValue.EMPTY_STRING, 0, 0);
            boolean empty = true;
            int i = 0;
            while (i < numArgs) {
                AtomicValue val = (AtomicValue)this.argument[i].evaluateItem(context);
                if (val != null) {
                    out.characters(val.getStringValueCS(), 0, 0);
                    empty = false;
                }
                ++i;
            }
            if (!empty) {
                out.append(StringValue.EMPTY_STRING, 0, 0);
            }
        } else {
            out.append(this.evaluateItem(context), 0, 0);
        }
    }
}

