/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CodeGeneratorService;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonItem;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public abstract class PJConverter
implements Serializable {
    private static HashMap<Class, SequenceType> jpmap = new HashMap();

    static {
        jpmap.put(Boolean.TYPE, SequenceType.SINGLE_BOOLEAN);
        jpmap.put(Boolean.class, SequenceType.OPTIONAL_BOOLEAN);
        jpmap.put(String.class, SequenceType.OPTIONAL_STRING);
        jpmap.put(CharSequence.class, SequenceType.OPTIONAL_STRING);
        jpmap.put(Long.TYPE, SequenceType.SINGLE_INTEGER);
        jpmap.put(Long.class, SequenceType.OPTIONAL_INTEGER);
        jpmap.put(Integer.TYPE, SequenceType.SINGLE_INTEGER);
        jpmap.put(Integer.class, SequenceType.OPTIONAL_INTEGER);
        jpmap.put(Short.TYPE, SequenceType.SINGLE_SHORT);
        jpmap.put(Short.class, SequenceType.OPTIONAL_SHORT);
        jpmap.put(Byte.TYPE, SequenceType.SINGLE_BYTE);
        jpmap.put(Byte.class, SequenceType.OPTIONAL_BYTE);
        jpmap.put(Float.TYPE, SequenceType.SINGLE_FLOAT);
        jpmap.put(Float.class, SequenceType.OPTIONAL_FLOAT);
        jpmap.put(Double.TYPE, SequenceType.SINGLE_DOUBLE);
        jpmap.put(Double.class, SequenceType.OPTIONAL_DOUBLE);
        jpmap.put(URI.class, SequenceType.OPTIONAL_ANY_URI);
        jpmap.put(URL.class, SequenceType.OPTIONAL_ANY_URI);
        jpmap.put(BigInteger.class, SequenceType.OPTIONAL_INTEGER);
        jpmap.put(BigDecimal.class, SequenceType.OPTIONAL_DECIMAL);
    }

    public static SequenceType getEquivalentItemType(Class javaClass) {
        return jpmap.get(javaClass);
    }

    public abstract Object convert(ValueRepresentation var1, Class var2, XPathContext var3) throws XPathException;

    public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
        throw new UnsupportedOperationException("Cannot generate Java code to support argument conversion for " + this.getClass());
    }

    public static PJConverter allocate(Configuration config, ItemType itemType, int cardinality, Class targetClass) throws XPathException {
        TypeHierarchy th = config.getTypeHierarchy();
        if (targetClass == SequenceIterator.class) {
            return ToSequenceIterator.INSTANCE;
        }
        if (targetClass == ValueRepresentation.class || targetClass == Item.class) {
            return Identity.INSTANCE;
        }
        if (targetClass == Value.class | targetClass == SequenceExtent.class) {
            return ToSequenceExtent.INSTANCE;
        }
        if (!itemType.isAtomicType()) {
            List<ExternalObjectModel> externalObjectModels = config.getExternalObjectModels();
            int m = 0;
            while (m < externalObjectModels.size()) {
                ExternalObjectModel model = externalObjectModels.get(m);
                PJConverter converter = model.getPJConverter(targetClass);
                if (converter != null) {
                    return converter;
                }
                ++m;
            }
            if (NodeInfo.class.isAssignableFrom(targetClass)) {
                return Identity.INSTANCE;
            }
        }
        if (Collection.class.isAssignableFrom(targetClass)) {
            return ToCollection.INSTANCE;
        }
        if (targetClass.isArray()) {
            PJConverter itemConverter = PJConverter.allocate(config, itemType, 16384, targetClass.getComponentType());
            return new ToArray(itemConverter);
        }
        if (!Cardinality.allowsMany(cardinality)) {
            if (itemType.isAtomicType()) {
                if (th.isSubType(itemType, BuiltInAtomicType.STRING)) {
                    if (targetClass == Object.class || targetClass == String.class || targetClass == CharSequence.class) {
                        return StringValueToString.INSTANCE;
                    }
                    if (targetClass.isAssignableFrom(StringValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (targetClass == Character.TYPE || targetClass == Character.class) {
                        return StringValueToChar.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (itemType == BuiltInAtomicType.UNTYPED_ATOMIC) {
                    if (targetClass == Object.class || targetClass == String.class || targetClass == CharSequence.class) {
                        return StringValueToString.INSTANCE;
                    }
                    if (targetClass.isAssignableFrom(UntypedAtomicValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.BOOLEAN)) {
                    if (targetClass == Object.class || targetClass == Boolean.class || targetClass == Boolean.TYPE) {
                        return BooleanValueToBoolean.INSTANCE;
                    }
                    if (targetClass.isAssignableFrom(BooleanValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.INTEGER)) {
                    if (targetClass == Object.class || targetClass == BigInteger.class) {
                        return IntegerValueToBigInteger.INSTANCE;
                    }
                    if (targetClass == Long.TYPE || targetClass == Long.class) {
                        return IntegerValueToLong.INSTANCE;
                    }
                    if (targetClass == Integer.TYPE || targetClass == Integer.class) {
                        return IntegerValueToInt.INSTANCE;
                    }
                    if (targetClass == Short.TYPE || targetClass == Short.class) {
                        return IntegerValueToShort.INSTANCE;
                    }
                    if (targetClass == Byte.TYPE || targetClass == Byte.class) {
                        return IntegerValueToByte.INSTANCE;
                    }
                    if (targetClass == Character.TYPE || targetClass == Character.class) {
                        return IntegerValueToChar.INSTANCE;
                    }
                    if (targetClass == Double.TYPE || targetClass == Double.class) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (targetClass == Float.TYPE || targetClass == Float.class) {
                        return NumericValueToFloat.INSTANCE;
                    }
                    if (targetClass == BigDecimal.class) {
                        return NumericValueToBigDecimal.INSTANCE;
                    }
                    if (targetClass.isAssignableFrom(IntegerValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.DECIMAL)) {
                    if (targetClass == Object.class || targetClass == BigDecimal.class) {
                        return NumericValueToBigDecimal.INSTANCE;
                    }
                    if (targetClass == Double.TYPE || targetClass == Double.class) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (targetClass == Float.TYPE || targetClass == Float.class) {
                        return NumericValueToFloat.INSTANCE;
                    }
                    if (targetClass.isAssignableFrom(DecimalValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.FLOAT)) {
                    if (targetClass == Object.class || targetClass == Float.class || targetClass == Float.TYPE) {
                        return NumericValueToFloat.INSTANCE;
                    }
                    if (targetClass == Double.TYPE || targetClass == Double.class) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (targetClass.isAssignableFrom(FloatValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.DOUBLE)) {
                    if (targetClass == Object.class || targetClass == Double.class || targetClass == Double.TYPE) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (targetClass.isAssignableFrom(DoubleValue.class)) {
                        return Identity.INSTANCE;
                    }
                    return Atomic.INSTANCE;
                }
                if (th.isSubType(itemType, BuiltInAtomicType.ANY_URI)) {
                    if (targetClass == Object.class || URI.class.isAssignableFrom(targetClass)) {
                        return AnyURIValueToURI.INSTANCE;
                    }
                    if (URL.class.isAssignableFrom(targetClass)) {
                        return AnyURIValueToURL.INSTANCE;
                    }
                    if (targetClass == String.class || targetClass == CharSequence.class) {
                        return StringValueToString.INSTANCE;
                    }
                    if (targetClass.isAssignableFrom(AnyURIValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.QNAME)) {
                    if (targetClass == Object.class || targetClass == QName.class) {
                        return QualifiedNameValueToQName.INSTANCE;
                    }
                    if (targetClass.isAssignableFrom(QNameValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.NOTATION)) {
                    if (targetClass == Object.class || targetClass == QName.class) {
                        return QualifiedNameValueToQName.INSTANCE;
                    }
                    if (targetClass.isAssignableFrom(NotationValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.DURATION)) {
                    if (targetClass.isAssignableFrom(DurationValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.DATE_TIME)) {
                    if (targetClass.isAssignableFrom(DateTimeValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (targetClass == Date.class) {
                        return CalendarValueToDate.INSTANCE;
                    }
                    if (targetClass == Calendar.class) {
                        return CalendarValueToCalendar.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.DATE)) {
                    if (targetClass.isAssignableFrom(DateValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (targetClass == Date.class) {
                        return CalendarValueToDate.INSTANCE;
                    }
                    if (targetClass == Calendar.class) {
                        return CalendarValueToCalendar.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.TIME)) {
                    if (targetClass.isAssignableFrom(TimeValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (targetClass == Date.class) {
                        return CalendarValueToDate.INSTANCE;
                    }
                    if (targetClass == Calendar.class) {
                        return CalendarValueToCalendar.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.G_YEAR)) {
                    if (targetClass.isAssignableFrom(GYearValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.G_YEAR_MONTH)) {
                    if (targetClass.isAssignableFrom(GYearMonthValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.G_MONTH)) {
                    if (targetClass.isAssignableFrom(GMonthValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.G_MONTH_DAY)) {
                    if (targetClass.isAssignableFrom(GMonthDayValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.G_DAY)) {
                    if (targetClass.isAssignableFrom(GDayValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.BASE64_BINARY)) {
                    if (targetClass.isAssignableFrom(Base64BinaryValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (th.isSubType(itemType, BuiltInAtomicType.HEX_BINARY)) {
                    if (targetClass.isAssignableFrom(HexBinaryValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, targetClass, config);
                }
                if (itemType instanceof ExternalObjectType) {
                    return UnwrapExternalObject.INSTANCE;
                }
                return Atomic.INSTANCE;
            }
            if (itemType instanceof EmptySequenceTest) {
                return ToNull.INSTANCE;
            }
            if (itemType instanceof NodeTest) {
                if (NodeInfo.class.isAssignableFrom(targetClass)) {
                    return Identity.INSTANCE;
                }
                return General.INSTANCE;
            }
            return General.INSTANCE;
        }
        return General.INSTANCE;
    }

    private static XPathException cannotConvert(ItemType source, Class target, Configuration config) {
        return new XPathException("Cannot convert from " + source.toString(config.getNamePool()) + " to " + target.getName());
    }

    public static PJConverter allocateNodeListCreator(Configuration config, Object node) {
        List<ExternalObjectModel> externalObjectModels = config.getExternalObjectModels();
        int m = 0;
        while (m < externalObjectModels.size()) {
            ExternalObjectModel model = externalObjectModels.get(m);
            PJConverter converter = model.getNodeListCreator(node);
            if (converter != null) {
                return converter;
            }
            ++m;
        }
        return ToCollection.INSTANCE;
    }

    public static class AnyURIValueToURI
    extends PJConverter {
        public static AnyURIValueToURI INSTANCE = new AnyURIValueToURI();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            try {
                return new URI(value.getStringValue());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathException("The anyURI value '" + value + "' is not an acceptable Java URI");
            }
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "new java.net.URI(" + var + ")";
        }
    }

    public static class AnyURIValueToURL
    extends PJConverter {
        public static AnyURIValueToURL INSTANCE = new AnyURIValueToURL();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            try {
                return new URL(value.getStringValue());
            }
            catch (MalformedURLException malformedURLException) {
                throw new XPathException("The anyURI value '" + value + "' is not an acceptable Java URL");
            }
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "new java.net.URL(" + var + ".getStringValue())";
        }
    }

    public static class Atomic
    extends PJConverter {
        public static Atomic INSTANCE = new Atomic();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            AtomicValue item = (AtomicValue)Value.asItem(value);
            if (item == null) {
                return null;
            }
            Configuration config = context.getConfiguration();
            PJConverter converter = Atomic.allocate(config, item.getItemType(config.getTypeHierarchy()), 16384, targetClass);
            return converter.convert(item, targetClass, context);
        }
    }

    public static class BooleanValueToBoolean
    extends PJConverter {
        public static BooleanValueToBoolean INSTANCE = new BooleanValueToBoolean();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            BooleanValue bv = (BooleanValue)Value.asItem(value);
            return bv.getBooleanValue();
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, BooleanValue.class)) + ".getBooleanValue()";
        }
    }

    public static class CalendarValueToCalendar
    extends PJConverter {
        public static CalendarValueToCalendar INSTANCE = new CalendarValueToCalendar();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            CalendarValue cv = (CalendarValue)Value.asItem(value);
            return cv.getCalendar();
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, CalendarValue.class)) + ".getCalendar()";
        }
    }

    public static class CalendarValueToDate
    extends PJConverter {
        public static CalendarValueToDate INSTANCE = new CalendarValueToDate();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            CalendarValue cv = (CalendarValue)Value.asItem(value);
            return cv.getCalendar().getTime();
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, CalendarValue.class)) + ".getCalendar().getTime()";
        }
    }

    public static class General
    extends PJConverter {
        public static General INSTANCE = new General();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            Value val = Value.asValue(value).reduce();
            Configuration config = context.getConfiguration();
            PJConverter converter = General.allocate(config, val.getItemType(config.getTypeHierarchy()), val.getCardinality(), targetClass);
            if (converter instanceof General) {
                converter = Identity.INSTANCE;
            }
            return converter.convert(val, targetClass, context);
        }
    }

    public static class Identity
    extends PJConverter {
        public static Identity INSTANCE = new Identity();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            Object obj;
            if (value instanceof SingletonItem) {
                value = ((SingletonItem)value).getItem();
            }
            if (value instanceof VirtualNode && targetClass.isAssignableFrom((obj = ((VirtualNode)value).getRealNode()).getClass())) {
                return obj;
            }
            if (targetClass.isAssignableFrom(value.getClass())) {
                return value;
            }
            ValueRepresentation val = Value.asValue(value).reduce();
            if (val instanceof SingletonItem) {
                val = ((SingletonItem)val).getItem();
            }
            if (targetClass.isAssignableFrom(val.getClass())) {
                return val;
            }
            if (val instanceof EmptySequence) {
                return null;
            }
            throw new XPathException("Cannot convert value " + val.getClass() + " of type " + Value.asValue(value).getItemType(context.getConfiguration().getTypeHierarchy()) + " to class " + targetClass.getName());
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "(" + targetClass.getName() + ")" + var;
        }
    }

    public static class IntegerValueToBigInteger
    extends PJConverter {
        public static IntegerValueToBigInteger INSTANCE = new IntegerValueToBigInteger();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            return ((IntegerValue)value).asBigInteger();
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, IntegerValue.class)) + ".asBigInteger()";
        }
    }

    public static class IntegerValueToByte
    extends PJConverter {
        public static IntegerValueToByte INSTANCE = new IntegerValueToByte();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            IntegerValue iv = (IntegerValue)Value.asItem(value);
            return new Byte((byte)iv.longValue());
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "(byte)" + compiler.cast(var, IntegerValue.class) + ".longValue()";
        }
    }

    public static class IntegerValueToChar
    extends PJConverter {
        public static IntegerValueToChar INSTANCE = new IntegerValueToChar();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            IntegerValue iv = (IntegerValue)Value.asItem(value);
            return new Character((char)iv.longValue());
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "(char)" + compiler.cast(var, IntegerValue.class) + ".longValue()";
        }
    }

    public static class IntegerValueToInt
    extends PJConverter {
        public static IntegerValueToInt INSTANCE = new IntegerValueToInt();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            IntegerValue iv = (IntegerValue)Value.asItem(value);
            return new Integer((int)iv.longValue());
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "(int)" + compiler.cast(var, IntegerValue.class) + ".longValue()";
        }
    }

    public static class IntegerValueToLong
    extends PJConverter {
        public static IntegerValueToLong INSTANCE = new IntegerValueToLong();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            IntegerValue iv = (IntegerValue)Value.asItem(value);
            return new Long(iv.longValue());
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, IntegerValue.class)) + ".longValue()";
        }
    }

    public static class IntegerValueToShort
    extends PJConverter {
        public static IntegerValueToShort INSTANCE = new IntegerValueToShort();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            IntegerValue iv = (IntegerValue)Value.asItem(value);
            return new Short((short)iv.longValue());
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "(short)" + compiler.cast(var, IntegerValue.class) + ".longValue()";
        }
    }

    public static class NumericValueToBigDecimal
    extends PJConverter {
        public static NumericValueToBigDecimal INSTANCE = new NumericValueToBigDecimal();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            NumericValue nv = (NumericValue)Value.asItem(value);
            return nv.getDecimalValue();
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, NumericValue.class)) + ".getDecimalValue()";
        }
    }

    public static class NumericValueToDouble
    extends PJConverter {
        public static NumericValueToDouble INSTANCE = new NumericValueToDouble();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            NumericValue nv = (NumericValue)Value.asItem(value);
            return new Double(nv.getDoubleValue());
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, NumericValue.class)) + ".getDoubleValue()";
        }
    }

    public static class NumericValueToFloat
    extends PJConverter {
        public static NumericValueToFloat INSTANCE = new NumericValueToFloat();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            NumericValue nv = (NumericValue)Value.asItem(value);
            return new Float(nv.getFloatValue());
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, NumericValue.class)) + ".getFloatValue()";
        }
    }

    public static class QualifiedNameValueToQName
    extends PJConverter {
        public static QualifiedNameValueToQName INSTANCE = new QualifiedNameValueToQName();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            QualifiedNameValue qv = (QualifiedNameValue)Value.asItem(value);
            return qv.toJaxpQName();
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, QualifiedNameValue.class)) + ".toJaxpQName()";
        }
    }

    public static class StringValueToChar
    extends PJConverter {
        public static StringValueToChar INSTANCE = new StringValueToChar();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            String str = value.getStringValue();
            if (str.length() == 1) {
                return new Character(str.charAt(0));
            }
            XPathException de = new XPathException("Cannot convert xs:string to Java char unless length is 1");
            de.setXPathContext(context);
            de.setErrorCode("SXJE0005");
            throw de;
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, StringValue.class)) + ".getStringValue().charAt(0)";
        }
    }

    public static class StringValueToString
    extends PJConverter {
        public static StringValueToString INSTANCE = new StringValueToString();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            return value.getStringValue();
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return String.valueOf(compiler.cast(var, StringValue.class)) + ".getStringValue()";
        }
    }

    public static class ToArray
    extends PJConverter {
        private PJConverter itemConverter;

        public ToArray(PJConverter itemConverter) {
            this.itemConverter = itemConverter;
        }

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            Item item;
            Class<?> componentClass = targetClass.getComponentType();
            ArrayList<Object> list = new ArrayList<Object>(20);
            SequenceIterator iter = Value.asIterator(value);
            while ((item = iter.next()) != null) {
                Object obj = this.itemConverter.convert(item, componentClass, context);
                if (obj == null) continue;
                list.add(obj);
            }
            Object array = Array.newInstance(componentClass, list.size());
            int i = 0;
            while (i < list.size()) {
                Array.set(array, i, list.get(i));
                ++i;
            }
            return array;
        }
    }

    public static class ToCollection
    extends PJConverter {
        public static ToCollection INSTANCE = new ToCollection();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            Collection<Object> list;
            if (targetClass.isAssignableFrom(ArrayList.class)) {
                list = new ArrayList(100);
            } else {
                try {
                    list = (Collection)targetClass.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    XPathException de = new XPathException("Cannot instantiate collection class " + targetClass);
                    de.setXPathContext(context);
                    throw de;
                }
                catch (IllegalAccessException illegalAccessException) {
                    XPathException de = new XPathException("Cannot access collection class " + targetClass);
                    de.setXPathContext(context);
                    throw de;
                }
            }
            Configuration config = context.getConfiguration();
            TypeHierarchy th = config.getTypeHierarchy();
            SequenceIterator iter = Value.asIterator(value);
            Item it;
            while ((it = iter.next()) != null) {
                if (it instanceof AtomicValue) {
                    PJConverter pj = ToCollection.allocate(config, ((AtomicValue)it).getItemType(th), 16384, Object.class);
                    list.add(pj.convert(it, Object.class, context));
                    continue;
                }
                if (it instanceof VirtualNode) {
                    list.add(((VirtualNode)it).getRealNode());
                    continue;
                }
                list.add(it);
            }
            return list;
        }
    }

    public static class ToNull
    extends PJConverter {
        public static ToNull INSTANCE = new ToNull();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            return null;
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "null";
        }
    }

    public static class ToSequenceExtent
    extends PJConverter {
        public static ToSequenceExtent INSTANCE = new ToSequenceExtent();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            return SequenceExtent.makeSequenceExtent(Value.asIterator(value));
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "SequenceExtent.makeSequenceExtent(Value.asIterator(" + var + "))";
        }
    }

    public static class ToSequenceIterator
    extends PJConverter {
        public static ToSequenceIterator INSTANCE = new ToSequenceIterator();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            return Value.asIterator(value);
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "Value.asIterator(" + var + ")";
        }
    }

    public static class UnwrapExternalObject
    extends PJConverter {
        public static UnwrapExternalObject INSTANCE = new UnwrapExternalObject();

        @Override
        public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
            Value val = Value.asValue(value).reduce();
            if (!(val instanceof ObjectValue)) {
                throw new XPathException("Expected external object of class " + targetClass + ", got " + val.getClass());
            }
            Object obj = ((ObjectValue)val).getObject();
            if (!targetClass.isAssignableFrom(obj.getClass())) {
                throw new XPathException("External object has wrong class (is " + obj.getClass().getName() + ", expected " + targetClass.getName());
            }
            return obj;
        }

        @Override
        public String compile(String var, Class targetClass, CodeGeneratorService compiler) {
            return "(" + targetClass.getName() + ")" + compiler.cast(var, ObjectValue.class) + ".getObject()";
        }
    }
}

