/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public final class IsLastExpression
extends Expression {
    private boolean condition;

    public IsLastExpression(boolean condition) {
        this.condition = condition;
    }

    public boolean getCondition() {
        return this.condition;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        return BooleanValue.get(this.condition == c.isAtLast());
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 12;
    }

    @Override
    public Expression copy() {
        return new IsLastExpression(this.condition);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("isLast");
        destination.emitAttribute("condition", this.condition ? "true" : "false");
        destination.endElement();
    }
}

