/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class AppendIterator
implements SequenceIterator {
    private SequenceIterator first;
    private SequenceIterable second;
    private XPathContext context;
    private SequenceIterator currentIterator;
    private int position = 0;

    public AppendIterator(SequenceIterator first, SequenceIterable second, XPathContext context) {
        this.first = first;
        this.second = second;
        this.context = context;
        this.currentIterator = first;
    }

    @Override
    public Item next() throws XPathException {
        Item n = this.currentIterator.next();
        if (n == null && this.currentIterator == this.first) {
            this.currentIterator = this.second.iterate(this.context);
            n = this.currentIterator.next();
        }
        this.position = n == null ? -1 : ++this.position;
        return n;
    }

    @Override
    public Item current() {
        return this.currentIterator.current();
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        return new AppendIterator(this.first.getAnother(), this.second, this.context);
    }

    @Override
    public int getProperties() {
        return 0;
    }
}

